/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.contols;

import java.io.File;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.ClassSelectionButton;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.IMenuButtonProvider;
import org.eclipse.birt.data.oda.pojo.ui.impl.dialogs.JarsSelectionDialog;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.ClassPathElement;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;

public class MenuButtonProvider
implements IMenuButtonProvider {
    private static String BUTTON_JAR_TEXT = Messages.getString("DataSource.POJOClassTabFolderPage.menuButton.addJar");
    private static String RELATIVE_PATH_MENU = Messages.getString("DataSource.POJOClassTabFolderPage.menuButton.item.relativePath");
    private static String ABSOLUTE_PATH_MENU = Messages.getString("DataSource.POJOClassTabFolderPage.menuButton.item.absolutePath");
    private ClassSelectionButton button;
    private String[] optionTypes = new String[]{ClassPathElement.ABSOLUTE_PATH};

    public String getDefaultOptionType() {
        return this.optionTypes == null || this.optionTypes.length == 0 ? null : this.optionTypes[0];
    }

    @Override
    public String[] getMenuItems() {
        return this.optionTypes;
    }

    @Override
    public Image getMenuItemImage(String type) {
        return null;
    }

    @Override
    public String getMenuItemText(String type) {
        if (ClassPathElement.RELATIVE_PATH.equals(type)) {
            return RELATIVE_PATH_MENU;
        }
        return ABSOLUTE_PATH_MENU;
    }

    @Override
    public String getTooltipText(String type) {
        return ClassPathElement.RELATIVE_PATH.equals(type) ? Messages.getString("DataSource.button.tooltip.AddRelativeJars") : Messages.getString("DataSource.button.tooltip.AddAbsoluteJars");
    }

    @Override
    public void handleSelectionEvent(String type) {
        Object value = this.button.getMenuButtonHelper().getPropertyValue("ResourceFileDIR");
        String[] fileNames = null;
        String rootPath = null;
        boolean isRelative = ClassPathElement.RELATIVE_PATH.equals(type);
        if (isRelative) {
            if (value != null && value instanceof File) {
                JarsSelectionDialog dialog = new JarsSelectionDialog(this.button.getControl().getShell(), (File)value);
                if (dialog.open() == 0) {
                    fileNames = dialog.getSelectedItems();
                }
            } else {
                ExceptionHandler.openErrorMessageBox((String)Messages.getString("DataSource.POJOClassTabFolderPage.error.title.empty.resourceIdentifier"), (String)Messages.getString("DataSource.POJOClassTabFolderPage.error.message.empty.resourceIdentifier"));
            }
        } else {
            FileDialog dialog = new FileDialog(this.button.getControl().getShell(), 2);
            dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
            if (dialog.open() != null) {
                fileNames = dialog.getFileNames();
                rootPath = dialog.getFilterPath();
            }
        }
        if (fileNames != null) {
            this.button.handleSelection(fileNames, rootPath, isRelative);
        }
    }

    @Override
    public void setInput(ClassSelectionButton input) {
        this.button = input;
    }

    public void resetProperties() {
        boolean supportsRelativePath = this.button.getMenuButtonHelper().getPropertyValue("ResourceFileDIR") instanceof File;
        this.optionTypes = supportsRelativePath ? new String[]{ClassPathElement.RELATIVE_PATH, ClassPathElement.ABSOLUTE_PATH} : new String[]{ClassPathElement.ABSOLUTE_PATH};
    }

    @Override
    public String getButtonImage() {
        return null;
    }

    @Override
    public String getButtonText() {
        return BUTTON_JAR_TEXT;
    }
}

