/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.themes;

import java.io.InputStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.tm4e.registry.TMResource;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.ITokenProvider;
import org.eclipse.tm4e.ui.themes.css.CSSTokenProvider;

public class Theme
extends TMResource
implements ITheme {
    private static final String DARK_ATTR = "dark";
    private static final String DEFAULT_ATTR = "default";
    private ITokenProvider tokenProvider;
    private String id;
    private String name;
    private boolean dark;
    private boolean isDefault;

    public Theme() {
    }

    public Theme(String id, String path, String name, boolean dark, boolean isDefault) {
        super(path);
        this.id = id;
        this.name = name;
        this.dark = dark;
        this.isDefault = isDefault;
    }

    public Theme(IConfigurationElement ce) {
        super(ce);
        this.id = ce.getAttribute("id");
        this.name = ce.getAttribute("name");
        this.dark = "true".equals(ce.getAttribute(DARK_ATTR));
        this.isDefault = "true".equals(ce.getAttribute(DEFAULT_ATTR));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IToken getToken(String type) {
        return this.getTokenProvider().getToken(type);
    }

    @Override
    public Color getEditorForeground() {
        return this.getTokenProvider().getEditorForeground();
    }

    @Override
    public Color getEditorBackground() {
        return this.getTokenProvider().getEditorBackground();
    }

    @Override
    public Color getEditorSelectionForeground() {
        return this.getTokenProvider().getEditorSelectionForeground();
    }

    @Override
    public Color getEditorSelectionBackground() {
        return this.getTokenProvider().getEditorSelectionBackground();
    }

    @Override
    public Color getEditorCurrentLineHighlight() {
        return this.getTokenProvider().getEditorCurrentLineHighlight();
    }

    private ITokenProvider getTokenProvider() {
        if (this.tokenProvider == null) {
            InputStream in;
            block4: {
                in = super.getInputStream();
                if (in != null) break block4;
                return null;
            }
            try {
                this.tokenProvider = new CSSTokenProvider(in);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.tokenProvider;
    }

    @Override
    public String toCSSStyleSheet() {
        return super.getResourceContent();
    }

    @Override
    public boolean isDark() {
        return this.dark;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void initializeViewerColors(StyledText styledText) {
        Color selectionBackground;
        Color foreground;
        ITokenProvider tokenProvider = this.getTokenProvider();
        Color background = tokenProvider.getEditorBackground();
        if (background != null) {
            styledText.setBackground(background);
        }
        if ((foreground = tokenProvider.getEditorForeground()) != null) {
            styledText.setForeground(foreground);
        }
        if ((selectionBackground = tokenProvider.getEditorSelectionBackground()) != null) {
            styledText.setSelectionBackground(selectionBackground);
        }
        Color selectionForeground = tokenProvider.getEditorSelectionForeground();
        styledText.setSelectionForeground(null);
        if (selectionForeground != null) {
            styledText.setSelectionForeground(selectionForeground);
        }
    }
}

