/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.events;

import java.util.EventObject;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;

public class ChangeEvent
extends EventObject {
    private static final long serialVersionUID = -7859159130977760588L;
    public static final String ID_ADDED = "added";
    public static final String ID_REMOVED = "removed";
    public static final String ID_CHANGED = "changed";
    private Object eventId;
    private Object oldValue;
    private Object newValue;

    public ChangeEvent(Object source, Object eventId, Object oldValue, Object newValue) {
        super(source);
        if (eventId == null) {
            throw new IllegalArgumentException("null eventId");
        }
        this.eventId = eventId;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public final Object getEventId() {
        return this.eventId;
    }

    public final Object getOldValue() {
        return this.oldValue;
    }

    public final Object getNewValue() {
        return this.newValue;
    }

    private Object formatValue(Object value) {
        Object formattedValue = value;
        if (value != null && value.getClass().isArray()) {
            StringBuilder str = new StringBuilder();
            str.append("{");
            int i = 0;
            while (i < ((Object[])value).length) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(this.formatValue(((Object[])value)[i]));
                ++i;
            }
            str.append("}");
            formattedValue = str.toString();
        }
        return formattedValue;
    }

    @Override
    public String toString() {
        StringBuilder toString = new StringBuilder(this.getClass().getName());
        String prefix = "";
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/events")) {
            prefix = "\n\t\t";
        }
        toString.append(String.valueOf(prefix) + "{eventId=");
        toString.append(this.eventId);
        toString.append("," + prefix + "source=");
        toString.append(this.source);
        toString.append("," + prefix + "oldValue=");
        toString.append(this.formatValue(this.oldValue));
        toString.append("," + prefix + "newValue=");
        toString.append(this.formatValue(this.newValue));
        toString.append("}");
        return toString.toString();
    }
}

