/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.server;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.generator.framework.Generator;
import org.eclipse.swtbot.generator.listener.WorkbenchListener;
import org.eclipse.swtbot.generator.server.RecorderServer;
import org.eclipse.swtbot.generator.ui.BotGeneratorEventDispatcher;
import org.eclipse.swtbot.generator.ui.GeneratorExtensionPointManager;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class StartupRecorderServer
implements IStartup {
    public static final String ENABLED_WITH_PORT = "org.eclipse.swtbot.generator.server.enable";
    private static final int[] monitoredEvents = new int[]{26, 21, 13, 17, 24, 3, 8, 1, 21};

    public void start(int port) {
        Display display = Display.getDefault();
        StartRecorderServerRunnable serverRunnable = new StartRecorderServerRunnable(display, port);
        display.syncExec((Runnable)serverRunnable);
    }

    public void earlyStartup() {
        if (System.getProperty(ENABLED_WITH_PORT) == null) {
            return;
        }
        try {
            int port = Integer.parseInt(System.getProperty(ENABLED_WITH_PORT));
            this.start(port);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("SWTBot recorder server launch aborted. org.eclipse.swtbot.generator.server.enable argument must be assigned an integer as a port number");
            return;
        }
    }

    private static final class StartRecorderServerRunnable
    implements Runnable {
        private final Display display;
        private int port;

        public StartRecorderServerRunnable(Display display, int port) {
            this.display = display;
            this.port = port;
        }

        @Override
        public void run() {
            IWorkbenchPage page;
            List<Generator> availableGenerators = GeneratorExtensionPointManager.loadGenerators();
            Generator generator = availableGenerators.get(0);
            BotGeneratorEventDispatcher dispatcher = new BotGeneratorEventDispatcher();
            dispatcher.setGenerator(generator);
            ArrayList<Shell> ignoreList = new ArrayList<Shell>();
            dispatcher.ignoreShells(ignoreList);
            int[] nArray = monitoredEvents;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int monitoredEvent = nArray[n2];
                this.display.addFilter(monitoredEvent, (Listener)dispatcher);
                ++n2;
            }
            if (PlatformUI.isWorkbenchRunning() && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                page.addPartListener((IPartListener2)new WorkbenchListener(dispatcher));
            }
            RecorderServer recorderServer = new RecorderServer(dispatcher);
            recorderServer.start(this.port);
        }
    }
}

