/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import javax.inject.Singleton;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.utils.Checks;

@Singleton
public class CachingAstProvider
implements IAstProvider,
IElementChangedListener {
    private final Cache<ICompilationUnit, CompilationUnit> cache = CacheBuilder.newBuilder().maximumSize(20L).build();

    @Override
    public CompilationUnit get(ICompilationUnit compilationUnit) {
        CompilationUnit ast = (CompilationUnit)this.cache.getIfPresent((Object)compilationUnit);
        if (ast == null && (ast = SharedASTProvider.getAST((ITypeRoot)compilationUnit, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null)) != null) {
            this.cache.put((Object)compilationUnit, (Object)ast);
        }
        return ast;
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        CompilationUnit ast = delta.getCompilationUnitAST();
        if (ast == null) {
            return;
        }
        ICompilationUnit cu = (ICompilationUnit)Checks.cast((Object)ast.getJavaElement());
        if (cu == null) {
            return;
        }
        this.cache.put((Object)cu, (Object)ast);
    }
}

