/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.results;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.DetailResultProvider;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.registry.QueryObjectLink;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.util.IProgressListener;

public class TextResult
implements IResult {
    private ResultMetaData metaData;
    private LinkedResults links;
    private boolean isHtml;
    private String text;

    public TextResult() {
        this("", true);
    }

    public TextResult(String text) {
        this(text, false);
    }

    public TextResult(String text, boolean isHtml) {
        this.text = text;
        this.isHtml = isHtml;
    }

    public ResultMetaData getResultMetaData() {
        return this.metaData;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public boolean isHtml() {
        return this.isHtml;
    }

    public String linkTo(String label, IResult result) {
        if (this.metaData == null) {
            this.links = new LinkedResults();
            this.metaData = new ResultMetaData.Builder().addDetailResult(this.links).build();
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<a href=\"");
        buf.append(this.links.add(result));
        buf.append("\">");
        buf.append(label);
        buf.append("</a>");
        return buf.toString();
    }

    private static class LinkedResults
    extends DetailResultProvider {
        private List<IResult> results = new ArrayList<IResult>();

        public LinkedResults() {
            super(Messages.TextResult_Label_Links);
        }

        public String add(IResult result) {
            this.results.add(result);
            return QueryObjectLink.forDetailResult(this, String.valueOf(this.results.size() - 1));
        }

        public IResult getResult(Object row, IProgressListener listener) throws SnapshotException {
            try {
                int index = Integer.parseInt((String)row);
                return this.results.get(index);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public boolean hasResult(Object row) {
            try {
                int index = Integer.parseInt((String)row);
                return index >= 0 && index < this.results.size();
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

