/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.ui.internal.exported.util.tree.menu;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.facet.util.ui.internal.exported.util.tree.item.AbstractTreeItem;
import org.eclipse.emf.facet.util.ui.internal.exported.util.tree.menu.AbstractTreeMenu;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeSubMenu<T>
extends AbstractTreeMenu<T> {
    private final List<AbstractTreeMenu<T>> items = new LinkedList<AbstractTreeMenu<T>>();

    public void addItem(AbstractTreeMenu<T> item) {
        this.getItems().add(item);
    }

    @Override
    protected MenuItem createMenuItem(Menu parent) {
        MenuItem menuItem = null;
        for (AbstractTreeMenu item : this.getItems()) {
            if (!item.isEnabled(this.getTreeMenu())) continue;
            if (menuItem == null) {
                menuItem = this.createConcreteMenu(parent);
            }
            item.setExtraProperties(this.getProperties());
            item.refresh(this.getTreeMenu(), menuItem.getMenu());
        }
        return menuItem;
    }

    protected MenuItem createConcreteMenu(Menu parent) {
        MenuItem menuItem = new MenuItem(parent, 64);
        menuItem.setText(this.getMenuName());
        menuItem.setMenu(new Menu(parent));
        return menuItem;
    }

    @Override
    public boolean isEnabled() {
        boolean result = false;
        for (AbstractTreeMenu item : this.getItems()) {
            if (!item.isEnabled(this.getTreeMenu())) continue;
            result = true;
        }
        return result;
    }

    @Override
    public AbstractTreeItem<T> getTreeItemExtended(TreeItem treeItem) {
        AbstractTreeItem<T> result = null;
        for (AbstractTreeMenu<T> menuItem : this.getItems()) {
            AbstractTreeItem<T> itemExtended = menuItem.getTreeItemExtended(treeItem);
            if (itemExtended == null) continue;
            result = itemExtended;
            break;
        }
        return result;
    }

    @Override
    public boolean removeItem(TreeItem item) {
        boolean removed = false;
        for (AbstractTreeMenu<T> menuItem : this.getItems()) {
            removed = menuItem.removeItem(item);
            if (removed) break;
        }
        return removed;
    }

    public List<AbstractTreeMenu<T>> getItems() {
        return this.items;
    }
}

