/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.providers;

import java.util.ArrayList;
import org.eclipse.bpmn2.Error;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.property.providers.BPMN2ErrorTreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.BPMN2MessageTreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.Messages;
import org.eclipse.bpmn2.modeler.ui.property.providers.TreeNode;
import org.eclipse.swt.graphics.Image;

public class BPMN2OperationTreeNode
extends TreeNode {
    public BPMN2OperationTreeNode(Operation operation, boolean isCondensed) {
        super(operation, isCondensed);
    }

    @Override
    public Object[] getChildren() {
        Operation operation = (Operation)this.modelObject;
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        if (operation.getInMessageRef() != null) {
            list.add(new BPMN2MessageTreeNode(operation.getInMessageRef(), this.isCondensed, true));
        }
        if (operation.getOutMessageRef() != null) {
            list.add(new BPMN2MessageTreeNode(operation.getOutMessageRef(), this.isCondensed, false));
        }
        if (!operation.getErrorRefs().isEmpty()) {
            for (Error e : operation.getErrorRefs()) {
                list.add(new BPMN2ErrorTreeNode(e, this.isCondensed));
            }
        }
        return list.toArray();
    }

    @Override
    public boolean hasChildren() {
        Operation operation = (Operation)this.modelObject;
        return operation.getInMessageRef() != null || operation.getOutMessageRef() != null || !operation.getErrorRefs().isEmpty();
    }

    @Override
    public Image getImage() {
        return Activator.getDefault().getImage("obj16/bpmn2operation.png");
    }

    @Override
    public String getLabel() {
        Operation op = (Operation)this.modelObject;
        String label = op.getName();
        if (label == null || label.isEmpty()) {
            label = Messages.BPMN2OperationTreeNode_Unnamed;
        }
        return label;
    }
}

