/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.apache.ode.deploy.ui.wizards;

import org.eclipse.bpel.apache.ode.deploy.ui.messages.ODEDeployUIMessages;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.wizards.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class ODEDeployWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private ISelection selection;
    private static final String DEPLOYFILE = "deploy.xml";

    public ODEDeployWizardPage(ISelection selection) {
        super(ODEDeployUIMessages.ODEDeployWizardPage_Name);
        this.setTitle(ODEDeployUIMessages.ODEDeployWizardPage_Title);
        this.setDescription(ODEDeployUIMessages.ODEDeployWizardPage_Description);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(ODEDeployUIMessages.ODEDeployWizardPage_Label_BPELProject);
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ODEDeployWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(ODEDeployUIMessages.ODEDeployWizardPage_Button_Browse);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ODEDeployWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(ODEDeployUIMessages.ODEDeployWizardPage_Label_DeployFile);
        this.fileText = new Text(container, 2052);
        this.fileText.setText(DEPLOYFILE);
        this.fileText.setEditable(false);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer bpelContent;
                IResource res = (IResource)obj;
                if (res instanceof IProject && (bpelContent = BPELUtil.getBPELContentFolder((IProject)res.getProject())) != null) {
                    res = bpelContent;
                }
                this.hasBPELContent(res);
                if (res instanceof IContainer) {
                    this.containerText.setText(res.getFullPath().toString());
                } else {
                    this.containerText.setText(res.getParent().getFullPath().toString());
                }
            }
        }
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, ODEDeployUIMessages.ODEDeployWizardPage_ContainerSelectionDialog_Message);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        if (this.getContainerName().length() == 0) {
            this.updateStatus(ODEDeployUIMessages.ODEDeployWizardPage_Error_Container_IsNULL);
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus(ODEDeployUIMessages.ODEDeployWizardPage_Error_Container_IsHere);
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(ODEDeployUIMessages.ODEDeployWizardPage_Error_Container_IsWritable);
            return;
        }
        this.hasBPELContent(container);
        this.updateStatus(null);
    }

    private void hasBPELContent(IResource res) {
        IContainer bpelContent = null;
        if (!BPELUtil.isBPELProject((IProject)res.getProject())) {
            this.setMessage(Messages.NewFileWizard_Not_A_BPELFaceted_Project, 2);
            return;
        }
        bpelContent = BPELUtil.getBPELContentFolder((IProject)res.getProject());
        if (!res.equals((Object)bpelContent) && !res.getParent().equals((Object)bpelContent)) {
            this.setMessage(Messages.NewFileWizard_Not_A_BPELContent_Folder, 2);
            return;
        }
        this.setMessage(null, 2);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }
}

