/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;

public class Namespaces {
    public static final Set<Namespace> DEFAULT_RDFA11;
    public static final Set<Namespace> DEFAULT_RDF4J;

    public static Map<String, String> asMap(Set<Namespace> namespaces) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Namespace nextNamespace : namespaces) {
            result.put(nextNamespace.getPrefix(), nextNamespace.getName());
        }
        return result;
    }

    public static Map<String, String> wrap(final Set<Namespace> namespaces) {
        return new Map<String, String>(){

            @Override
            public void clear() {
                namespaces.clear();
            }

            @Override
            public boolean containsKey(Object nextKey) {
                if (nextKey instanceof String) {
                    for (Namespace nextNamespace : namespaces) {
                        if (!nextNamespace.getPrefix().equals(nextKey)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean containsValue(Object nextValue) {
                if (nextValue instanceof String) {
                    for (Namespace nextNamespace : namespaces) {
                        if (!nextNamespace.getName().equals(nextValue)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                LinkedHashSet<AbstractMap.SimpleImmutableEntry<String, String>> result = new LinkedHashSet<AbstractMap.SimpleImmutableEntry<String, String>>();
                for (Namespace nextNamespace : namespaces) {
                    AbstractMap.SimpleImmutableEntry<String, String> nextEntry = new AbstractMap.SimpleImmutableEntry<String, String>(nextNamespace.getPrefix(), nextNamespace.getName());
                    result.add(nextEntry);
                }
                return Collections.unmodifiableSet(result);
            }

            @Override
            public String get(Object nextKey) {
                if (nextKey instanceof String) {
                    for (Namespace nextNamespace : namespaces) {
                        if (!nextNamespace.getPrefix().equals(nextKey)) continue;
                        return nextNamespace.getName();
                    }
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return namespaces.isEmpty();
            }

            @Override
            public Set<String> keySet() {
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                for (Namespace nextNamespace : namespaces) {
                    result.add(nextNamespace.getPrefix());
                }
                return result;
            }

            @Override
            public String put(String nextKey, String nextValue) {
                String result = null;
                for (Namespace nextNamespace : new LinkedHashSet(namespaces)) {
                    if (!nextNamespace.getPrefix().equals(nextKey)) continue;
                    result = nextNamespace.getName();
                    namespaces.remove(nextNamespace);
                }
                namespaces.add(new SimpleNamespace(nextKey, nextValue));
                return result;
            }

            @Override
            public void putAll(Map<? extends String, ? extends String> nextSet) {
                for (Map.Entry<? extends String, ? extends String> nextEntry : nextSet.entrySet()) {
                    this.put(nextEntry.getKey(), nextEntry.getValue());
                }
            }

            @Override
            public String remove(Object nextKey) {
                String result = null;
                for (Namespace nextNamespace : new LinkedHashSet(namespaces)) {
                    if (!nextNamespace.getPrefix().equals(nextKey)) continue;
                    result = nextNamespace.getName();
                    namespaces.remove(nextNamespace);
                }
                return result;
            }

            @Override
            public int size() {
                return namespaces.size();
            }

            @Override
            public Collection<String> values() {
                ArrayList<String> result = new ArrayList<String>();
                for (Namespace nextNamespace : namespaces) {
                    result.add(nextNamespace.getName());
                }
                return result;
            }
        };
    }

    private Namespaces() {
    }

    static {
        HashSet<SimpleNamespace> aNamespaces = new HashSet<SimpleNamespace>();
        aNamespaces.add(new SimpleNamespace("as", "https://www.w3.org/ns/activitystreams#"));
        aNamespaces.add(new SimpleNamespace("csvw", "http://www.w3.org/ns/csvw#"));
        aNamespaces.add(new SimpleNamespace("dcat", "http://www.w3.org/ns/dcat#"));
        aNamespaces.add(new SimpleNamespace("dqv", "http://www.w3.org/ns/dqv#"));
        aNamespaces.add(new SimpleNamespace("duv", "https://www.w3.org/TR/vocab-duv#"));
        aNamespaces.add(new SimpleNamespace("grddl", "http://www.w3.org/2003/g/data-view#"));
        aNamespaces.add(new SimpleNamespace("jsonld", "http://www.w3.org/ns/json-ld#"));
        aNamespaces.add(new SimpleNamespace("ldp", "http://www.w3.org/ns/ldp#"));
        aNamespaces.add(new SimpleNamespace("ma", "http://www.w3.org/ns/ma-ont#"));
        aNamespaces.add(new SimpleNamespace("oa", "http://www.w3.org/ns/oa#"));
        aNamespaces.add(new SimpleNamespace("odrl", "http://www.w3.org/ns/odrl/2/"));
        aNamespaces.add(new SimpleNamespace("org", "http://www.w3.org/ns/org#"));
        aNamespaces.add(new SimpleNamespace("owl", "http://www.w3.org/2002/07/owl#"));
        aNamespaces.add(new SimpleNamespace("prov", "http://www.w3.org/ns/prov#"));
        aNamespaces.add(new SimpleNamespace("qb", "http://purl.org/linked-data/cube#"));
        aNamespaces.add(new SimpleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        aNamespaces.add(new SimpleNamespace("rdfa", "http://www.w3.org/ns/rdfa#"));
        aNamespaces.add(new SimpleNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#"));
        aNamespaces.add(new SimpleNamespace("rif", "http://www.w3.org/2007/rif#"));
        aNamespaces.add(new SimpleNamespace("rr", "http://www.w3.org/ns/r2rml#"));
        aNamespaces.add(new SimpleNamespace("sd", "http://www.w3.org/ns/sparql-service-description#"));
        aNamespaces.add(new SimpleNamespace("skos", "http://www.w3.org/2004/02/skos/core#"));
        aNamespaces.add(new SimpleNamespace("skosxl", "http://www.w3.org/2008/05/skos-xl#"));
        aNamespaces.add(new SimpleNamespace("ssn", "http://www.w3.org/ns/ssn/"));
        aNamespaces.add(new SimpleNamespace("sosa", "http://www.w3.org/ns/sosa/"));
        aNamespaces.add(new SimpleNamespace("time", "http://www.w3.org/2006/time#"));
        aNamespaces.add(new SimpleNamespace("void", "http://rdfs.org/ns/void#"));
        aNamespaces.add(new SimpleNamespace("wdr", "http://www.w3.org/2007/05/powder#"));
        aNamespaces.add(new SimpleNamespace("wdrs", "http://www.w3.org/2007/05/powder-s#"));
        aNamespaces.add(new SimpleNamespace("xhv", "http://www.w3.org/1999/xhtml/vocab#"));
        aNamespaces.add(new SimpleNamespace("xml", "http://www.w3.org/XML/1998/namespace"));
        aNamespaces.add(new SimpleNamespace("xsd", "http://www.w3.org/2001/XMLSchema#"));
        aNamespaces.add(new SimpleNamespace("earl", "http://www.w3.org/ns/earl#"));
        aNamespaces.add(new SimpleNamespace("cc", "http://creativecommons.org/ns#"));
        aNamespaces.add(new SimpleNamespace("ctag", "http://commontag.org/ns#"));
        aNamespaces.add(new SimpleNamespace("dc", "http://purl.org/dc/terms/"));
        aNamespaces.add(new SimpleNamespace("dc11", "http://purl.org/dc/elements/1.1/"));
        aNamespaces.add(new SimpleNamespace("dcterms", "http://purl.org/dc/terms/"));
        aNamespaces.add(new SimpleNamespace("foaf", "http://xmlns.com/foaf/0.1/"));
        aNamespaces.add(new SimpleNamespace("gr", "http://purl.org/goodrelations/v1#"));
        aNamespaces.add(new SimpleNamespace("ical", "http://www.w3.org/2002/12/cal/icaltzd#"));
        aNamespaces.add(new SimpleNamespace("og", "http://ogp.me/ns#"));
        aNamespaces.add(new SimpleNamespace("rev", "http://purl.org/stuff/rev#"));
        aNamespaces.add(new SimpleNamespace("sioc", "http://rdfs.org/sioc/ns#"));
        aNamespaces.add(new SimpleNamespace("v", "http://rdf.data-vocabulary.org/#"));
        aNamespaces.add(new SimpleNamespace("vcard", "http://www.w3.org/2006/vcard/ns#"));
        aNamespaces.add(new SimpleNamespace("schema", "http://schema.org/"));
        aNamespaces.add(new SimpleNamespace("describedby", "http://www.w3.org/2007/05/powder-s#describedby"));
        aNamespaces.add(new SimpleNamespace("license", "http://www.w3.org/1999/xhtml/vocab#license"));
        aNamespaces.add(new SimpleNamespace("role", "http://www.w3.org/1999/xhtml/vocab#role"));
        DEFAULT_RDFA11 = Collections.unmodifiableSet(aNamespaces);
        HashSet<SimpleNamespace> bNamespaces = new HashSet<SimpleNamespace>();
        bNamespaces.addAll(aNamespaces);
        bNamespaces.add(new SimpleNamespace("cat", "http://www.w3.org/ns/dcat#"));
        bNamespaces.add(new SimpleNamespace("cnt", "http://www.w3.org/2008/content#"));
        bNamespaces.add(new SimpleNamespace("gldp", "http://www.w3.org/ns/people#"));
        bNamespaces.add(new SimpleNamespace("ht", "http://www.w3.org/2006/http#"));
        bNamespaces.add(new SimpleNamespace("ptr", "http://www.w3.org/2009/pointers#"));
        DEFAULT_RDF4J = Collections.unmodifiableSet(bNamespaces);
    }
}

