/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7Status;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.persistence.LeakDetector;
import org.eclipse.rcptt.core.persistence.PersistenceManager;
import org.eclipse.rcptt.core.persistence.plain.PlainTextPersistenceModel;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.internal.core.Q7LazyResource;
import org.eclipse.rcptt.internal.core.model.OpenableElementInfo;
import org.eclipse.rcptt.internal.core.model.cache.ILRUCacheable;

public class Q7ResourceInfo
extends OpenableElementInfo
implements ILRUCacheable,
Closeable {
    private final Resource resource;
    private NamedElement element;
    public long timestamp;
    private final String plainStoreFormat;
    private Runnable onClose = () -> {};
    private boolean closed = false;

    public Q7ResourceInfo(String storeFormat, URI uri) {
        this.plainStoreFormat = (String)Preconditions.checkNotNull((Object)storeFormat);
        Preconditions.checkNotNull((Object)uri);
        this.resource = new Q7LazyResource(uri);
        this.resource.setTrackingModification(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(IFile file) throws ModelException {
        Q7ResourceInfo q7ResourceInfo = this;
        synchronized (q7ResourceInfo) {
            if (this.resource == null) {
                throw new NullPointerException("Resource info " + this.plainStoreFormat + " can't be associated with a file");
            }
            if (this.closed) {
                Q7Status status = new Q7Status(0, String.valueOf(this.resource.getURI()) + " is already closed");
                status.setStatusCode(Q7Status.Q7StatusCode.NotOpen);
                throw new ModelException(status);
            }
        }
        if (file != null) {
            this.timestamp = file.getModificationStamp();
        }
        URI uri = Q7ResourceInfo.toURI(file);
        this.onClose = LeakDetector.INSTANCE.register(this);
        IPersistenceModel model = this.getPersistenceModel();
        if (file != null && !file.exists() || model == null) {
            throw this.newNotExistsException(file);
        }
        boolean allowEmptyMetadataContent = model.isAllowEmptyMetadataContent();
        try {
            Throwable throwable = null;
            Object var6_10 = null;
            try (InputStream metadataStream = this.openMetadata(model, file);){
                if (metadataStream != null) {
                    this.resource.load(metadataStream, PersistenceManager.getOptions());
                }
                model.updateMetadata();
                EList contents = this.resource.getContents();
                this.resource.setModified(false);
                if (contents.size() == 0) {
                    if (file != null && !file.exists()) {
                        throw this.newNotExistsException(file);
                    }
                    throw new ModelException(new Q7Status(0, "Empty resource " + String.valueOf(uri) + ". Empty metadata is " + (allowEmptyMetadataContent ? "" : "not ") + "allowed. File: " + String.valueOf(file == null ? null : file.getFullPath())));
                }
                for (EObject eObject : contents) {
                    if (!(eObject instanceof NamedElement)) continue;
                    this.element = (NamedElement)eObject;
                }
                if (this.element == null) {
                    throw new ModelException(new Q7Status(4, "Illegal object type: " + ((EObject)contents.get(0)).getClass().getName()));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            if (file != null && !file.exists()) {
                throw this.newNotExistsException(file);
            }
            ModelException modelException = new ModelException(e, 4);
            String content = null;
            try {
                Throwable contents = null;
                Object var9_23 = null;
                try (InputStream is = this.openMetadata(model, file);){
                    if (is != null) {
                        Throwable throwable = null;
                        Object var12_27 = null;
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.openMetadata(model, file), StandardCharsets.UTF_8));){
                            char[] buffer = new char[3000];
                            int length = reader.read(buffer);
                            if (length >= 0) {
                                content = new String(buffer, 0, length);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    modelException.addSuppressed(new RuntimeException("File content:\n" + content + "...\n"));
                }
                catch (Throwable throwable) {
                    if (contents == null) {
                        contents = throwable;
                    } else if (contents != throwable) {
                        contents.addSuppressed(throwable);
                    }
                    throw contents;
                }
            }
            catch (IOException e1) {
                modelException.addSuppressed((Throwable)((Object)modelException));
            }
            catch (CoreException e1) {
                modelException.addSuppressed(e1);
            }
            throw modelException;
        }
        finally {
            this.unload();
        }
    }

    private ModelException newNotExistsException(IFile file) {
        Q7Status status = new Q7Status(4, "Element: " + String.valueOf(file.getFullPath()) + " doesn't exist");
        status.setStatusCode(Q7Status.Q7StatusCode.NotPressent);
        ModelException exception = new ModelException(status);
        return exception;
    }

    public String toString() {
        return this.resource == null ? "null" : this.resource.getURI().toString();
    }

    public static URI toURI(IFile file) {
        return URI.createPlatformResourceURI((String)(file != null ? file.getFullPath().toString() : "__uri__"), (boolean)true);
    }

    protected IPersistenceModel getPersistenceModel() {
        return PersistenceManager.getInstance().getModel(this.resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        PersistenceManager.getInstance().remove(this.resource);
        Q7ResourceInfo q7ResourceInfo = this;
        synchronized (q7ResourceInfo) {
            this.element = null;
            this.timestamp = 0L;
            this.onClose.run();
            this.closed = true;
        }
    }

    public NamedElement getNamedElement() {
        return this.element;
    }

    public void extractAllPersistence() {
        this.getPersistenceModel().extractAll();
    }

    public void save() {
        IPersistenceModel model = this.getPersistenceModel();
        if (model instanceof PlainTextPersistenceModel) {
            ((PlainTextPersistenceModel)model).setSaveFormat(this.plainStoreFormat);
        }
        PersistenceManager.getInstance().saveResource(this.resource);
        this.resource.setModified(false);
        model.setUnmodified();
    }

    public IPersistenceModel getModel() {
        return this.getPersistenceModel();
    }

    public boolean hasChanges() {
        if (this.resource == null) {
            return true;
        }
        if (this.resource.isModified()) {
            return true;
        }
        return !Optional.ofNullable(this.getPersistenceModel()).filter(m -> !m.isModified()).isPresent();
    }

    public void createNamedElement(NamedElement createNamedElement) {
        this.element = createNamedElement;
        this.resource.getContents().add((Object)this.element);
    }

    public Resource getResource() {
        return this.resource;
    }

    public void updatePersistenceModel(IPersistenceModel newModel) {
        PersistenceManager.getInstance().replaceModelWith(this.resource, newModel);
    }

    @Override
    public int getCacheFootprint() {
        Resource res = this.getResource();
        if (res == null) {
            return 0;
        }
        return PersistenceManager.getInstance().cachedSize(res);
    }

    @Override
    public void close() {
        this.unload();
    }

    private InputStream openMetadata(IPersistenceModel model, IFile file) throws CoreException {
        InputStream metadataStream = PersistenceManager.getInstance().loadMetadata(model);
        if (metadataStream != null) {
            return metadataStream;
        }
        if (file != null && !model.isAllowEmptyMetadataContent()) {
            return file.getContents();
        }
        return null;
    }
}

