/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.index;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.core.model.index.IProjectIndexer;
import org.eclipse.rcptt.internal.core.model.index.IndexRequest;
import org.eclipse.rcptt.internal.core.model.index.NamedElementCollector;
import org.eclipse.rcptt.internal.core.model.index.NamedElementsRequest;

public class ProjectRequest
extends IndexRequest {
    private final IQ7Project project;

    public ProjectRequest(IProjectIndexer indexer, IQ7Project project) {
        super(indexer);
        this.project = project;
    }

    @Override
    protected String getName() {
        return this.project.getName();
    }

    @Override
    protected void run() throws CoreException {
        IProjectIndexer.Internal indexer = this.getIndexer();
        NamedElementCollector elementCollector = new NamedElementCollector();
        try {
            this.project.accept(elementCollector);
        }
        catch (InterruptedException | ModelException e) {
            throw new IllegalStateException((Throwable)e);
        }
        indexer.request(new NamedElementsRequest(indexer, this.project, elementCollector.getElements(), true));
    }

    @Override
    public boolean belongsTo(String jobFamily) {
        return jobFamily.equals(this.project.getProject().getName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectRequest other = (ProjectRequest)obj;
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }
}

