/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.jupiter.api.ClassTemplate;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.engine.discovery.predicates.IsTestFactoryMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestTemplateMethod;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.util.KotlinReflectionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

@API(status=API.Status.INTERNAL, since="5.13")
public class TestClassPredicates {
    public final Predicate<Class<?>> isAnnotatedWithNested = candidate -> TestClassPredicates.isAnnotatedButNotComposed(candidate, Nested.class);
    public final Predicate<Class<?>> isAnnotatedWithClassTemplate = candidate -> TestClassPredicates.isAnnotatedButNotComposed(candidate, ClassTemplate.class);
    public final Predicate<Class<?>> isAnnotatedWithNestedAndValid = candidate -> this.isAnnotatedWithNested.test((Class<?>)candidate) && this.isValidNestedTestClass((Class<?>)candidate);
    public final Predicate<Class<?>> looksLikeNestedOrStandaloneTestClass = candidate -> this.isAnnotatedWithNested.test((Class<?>)candidate) || this.looksLikeIntendedTestClass((Class<?>)candidate);
    public final Predicate<Method> isTestOrTestFactoryOrTestTemplateMethod;
    private final DiscoveryIssueReporter.Condition<Class<?>> isNotPrivateUnlessAbstractNestedClass;
    private final DiscoveryIssueReporter.Condition<Class<?>> isInnerNestedClass;
    private final DiscoveryIssueReporter.Condition<Class<?>> isValidStandaloneTestClass;

    public TestClassPredicates(DiscoveryIssueReporter issueReporter) {
        this.isTestOrTestFactoryOrTestTemplateMethod = new IsTestMethod(issueReporter).or(new IsTestFactoryMethod(issueReporter)).or(new IsTestTemplateMethod(issueReporter));
        this.isNotPrivateUnlessAbstractNestedClass = TestClassPredicates.isNotPrivateUnlessAbstract("@Nested", issueReporter);
        this.isInnerNestedClass = TestClassPredicates.isInner(issueReporter);
        this.isValidStandaloneTestClass = TestClassPredicates.isNotPrivateUnlessAbstract("Test", issueReporter).and(TestClassPredicates.isNotLocal(issueReporter)).and(TestClassPredicates.isNotInnerUnlessAbstract(issueReporter)).and(TestClassPredicates.isNotAnonymous(issueReporter));
    }

    public boolean looksLikeIntendedTestClass(Class<?> candidate) {
        return this.looksLikeIntendedTestClass(candidate, new HashSet());
    }

    private boolean looksLikeIntendedTestClass(Class<?> candidate, Set<Class<?>> seen) {
        if (seen.add(candidate) && !KotlinReflectionUtils.isKotlinInterfaceDefaultImplsClass(candidate)) {
            return this.isAnnotatedWithClassTemplate.test(candidate) || this.hasTestOrTestFactoryOrTestTemplateMethods(candidate) || this.hasNestedTests(candidate, seen);
        }
        return false;
    }

    public boolean isValidNestedTestClass(Class<?> candidate) {
        return this.validateNestedTestClass(candidate) == null;
    }

    public NestedClassInvalidityReason validateNestedTestClass(Class<?> candidate) {
        boolean isInner = this.isInnerNestedClass.check(candidate);
        boolean isNotPrivateUnlessAbstract = this.isNotPrivateUnlessAbstractNestedClass.check(candidate);
        if (isNotPrivateUnlessAbstract && ModifierSupport.isNotAbstract(candidate)) {
            return isInner ? null : NestedClassInvalidityReason.NOT_INNER;
        }
        return NestedClassInvalidityReason.OTHER;
    }

    public boolean isValidStandaloneTestClass(Class<?> candidate) {
        return this.isValidStandaloneTestClass.check(candidate) && ModifierSupport.isNotAbstract(candidate);
    }

    private boolean hasTestOrTestFactoryOrTestTemplateMethods(Class<?> candidate) {
        return ReflectionUtils.isMethodPresent(candidate, this.isTestOrTestFactoryOrTestTemplateMethod);
    }

    private boolean hasNestedTests(Class<?> candidate, Set<Class<?>> seen) {
        boolean hasAnnotatedClass = ReflectionUtils.isNestedClassPresent(candidate, this.isAnnotatedWithNested, (ReflectionUtils.CycleErrorHandling)ReflectionUtils.CycleErrorHandling.THROW_EXCEPTION);
        if (hasAnnotatedClass) {
            return true;
        }
        return ReflectionUtils.isNestedClassPresent(candidate, it -> ReflectionUtils.isInnerClass((Class)it) && this.looksLikeIntendedTestClass((Class<?>)it, seen), (ReflectionUtils.CycleErrorHandling)ReflectionUtils.CycleErrorHandling.ABORT_VISIT);
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotPrivateUnlessAbstract(String prefix, DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> ModifierSupport.isNotPrivate((Class)testClass) || ModifierSupport.isAbstract((Class)testClass), testClass -> TestClassPredicates.createIssue(prefix, testClass, "must not be private"));
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotLocal(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> !testClass.isLocalClass(), testClass -> TestClassPredicates.createIssue("Test", testClass, "must not be a local class"));
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isInner(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(ReflectionUtils::isInnerClass, testClass -> {
            if (testClass.getEnclosingClass() == null) {
                return TestClassPredicates.createIssue("Top-level", testClass, "must not be annotated with @Nested", "It will be executed anyway for backward compatibility. You should remove the @Nested annotation to resolve this warning.");
            }
            return TestClassPredicates.createIssue("@Nested", testClass, "must not be static", "It will only be executed if discovered as a standalone test class. You should remove the annotation or make it non-static to resolve this warning.");
        });
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotInnerUnlessAbstract(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> !ReflectionUtils.isInnerClass((Class)testClass) || ModifierSupport.isAbstract((Class)testClass), testClass -> TestClassPredicates.createIssue("Test", testClass, "must not be an inner class unless annotated with @Nested"));
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotAnonymous(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> !testClass.isAnonymousClass(), testClass -> TestClassPredicates.createIssue("Test", testClass, "must not be anonymous"));
    }

    private static DiscoveryIssue createIssue(String prefix, Class<?> testClass, String detailMessage) {
        return TestClassPredicates.createIssue(prefix, testClass, detailMessage, "It will not be executed.");
    }

    private static DiscoveryIssue createIssue(String prefix, Class<?> testClass, String detailMessage, String effect) {
        String message = String.format("%s class '%s' %s. %s", prefix, testClass.getName(), detailMessage, effect);
        return DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.WARNING, (String)message).source((TestSource)ClassSource.from(testClass)).build();
    }

    private static boolean isAnnotatedButNotComposed(Class<?> candidate, Class<? extends Annotation> annotationType) {
        return !candidate.isAnnotation() && AnnotationSupport.isAnnotated(candidate, annotationType);
    }

    @API(status=API.Status.INTERNAL, since="5.13.3")
    public static enum NestedClassInvalidityReason {
        NOT_INNER,
        OTHER;

    }
}

