/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.util.ASTHelper;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class StringBufferToStringBuilderFixCore
extends CompilationUnitRewriteOperationsFixCore {
    private static final String STRINGBUFFER_CLASS_NAME = StringBuffer.class.getCanonicalName();
    private static final String OBJECT_CLASS_NAME = Object.class.getCanonicalName();
    private static final String TOSTRING_NAME = "toString";
    private static final String STRINGBUIDER_NAME = "StringBuilder";

    private static boolean isStringBufferType(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            throw new AbortSearchException();
        }
        if (typeBinding.isArray()) {
            typeBinding = typeBinding.getElementType();
        }
        return typeBinding.getQualifiedName().equals(STRINGBUFFER_CLASS_NAME);
    }

    private static boolean isObjectType(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            throw new AbortSearchException();
        }
        if (typeBinding.isArray()) {
            typeBinding = typeBinding.getElementType();
        }
        return typeBinding.getQualifiedName().equals(OBJECT_CLASS_NAME);
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean forLocalsOnly) {
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        if (forLocalsOnly) {
            ArrayList<MethodDeclaration> validMethodDeclarations = new ArrayList<MethodDeclaration>();
            ValidLocalMethodFinder finder = new ValidLocalMethodFinder(validMethodDeclarations);
            compilationUnit.accept((ASTVisitor)finder);
            LocalsOnlyStringBufferFinder localsFinder = new LocalsOnlyStringBufferFinder(operations);
            for (MethodDeclaration methodDeclaration : validMethodDeclarations) {
                methodDeclaration.accept((ASTVisitor)localsFinder);
            }
        } else {
            StringBufferFinder finder = new StringBufferFinder(operations);
            compilationUnit.accept((ASTVisitor)finder);
        }
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new StringBufferToStringBuilderFixCore(FixMessages.StringBufferToStringBuilderFix_convert_msg, compilationUnit, ops);
    }

    protected StringBufferToStringBuilderFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static class ChangeStringBufferToStringBuilder
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final Type fType;
        private final SimpleName fName;
        private final MethodInvocation fInvocation;

        public ChangeStringBufferToStringBuilder(Type type) {
            this.fType = type;
            this.fName = null;
            this.fInvocation = null;
        }

        public ChangeStringBufferToStringBuilder(SimpleName name) {
            this.fType = null;
            this.fName = name;
            this.fInvocation = null;
        }

        public ChangeStringBufferToStringBuilder(MethodInvocation node) {
            this.fType = null;
            this.fName = null;
            this.fInvocation = node;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.StringBufferToStringBuilderCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            importRewrite.addImport(StringBuilder.class.getCanonicalName());
            if (this.fType != null) {
                rewrite.replace((ASTNode)this.fType, (ASTNode)ast.newSimpleType(ast.newName(StringBufferToStringBuilderFixCore.STRINGBUIDER_NAME)), group);
            } else if (this.fName != null) {
                rewrite.replace((ASTNode)this.fName, (ASTNode)ast.newSimpleName(StringBufferToStringBuilderFixCore.STRINGBUIDER_NAME), group);
            } else {
                ClassInstanceCreation cic = ast.newClassInstanceCreation();
                cic.setType((Type)ast.newSimpleType((Name)ast.newSimpleName(StringBufferToStringBuilderFixCore.STRINGBUIDER_NAME)));
                MethodInvocation copy = (MethodInvocation)rewrite.createCopyTarget((ASTNode)this.fInvocation);
                MethodInvocation newMethodInvocation = ast.newMethodInvocation();
                newMethodInvocation.setExpression((Expression)copy);
                newMethodInvocation.setName(ast.newSimpleName(StringBufferToStringBuilderFixCore.TOSTRING_NAME));
                cic.arguments().add(newMethodInvocation);
                rewrite.replace((ASTNode)this.fInvocation, (ASTNode)cic, group);
            }
        }
    }

    private static final class LocalVarChecker {
        private final ASTNode fNode;

        public LocalVarChecker(ASTNode node) {
            this.fNode = node;
        }

        public boolean isValid() {
            ASTVisitor visitor = new ASTVisitor(){

                public boolean visit(SimpleName visited) {
                    IVariableBinding varBinding;
                    IBinding binding = visited.resolveBinding();
                    if (binding == null) {
                        throw new AbortSearchException();
                    }
                    if (binding instanceof IVariableBinding && ((varBinding = (IVariableBinding)binding).isField() || varBinding.isParameter() || varBinding.isRecordComponent())) {
                        throw new AbortSearchException();
                    }
                    return false;
                }
            };
            try {
                this.fNode.accept(visitor);
                return true;
            }
            catch (AbortSearchException abortSearchException) {
                return false;
            }
        }
    }

    private static final class LocalsOnlyStringBufferFinder
    extends ASTVisitor {
        private final StringBufferFinder fStringBufferFinder;

        public LocalsOnlyStringBufferFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations) {
            this.fStringBufferFinder = new StringBufferFinder(operations);
        }

        public boolean visit(VariableDeclarationStatement visited) {
            Type type = visited.getType();
            ITypeBinding typeBinding = type.resolveBinding();
            if (StringBufferToStringBuilderFixCore.isStringBufferType(typeBinding)) {
                visited.accept((ASTVisitor)this.fStringBufferFinder);
                return false;
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation visited) {
            IVariableBinding leftSideVarBinding;
            IBinding leftSideBinding;
            Expression leftSide;
            Assignment assignment;
            Type type = visited.getType();
            ITypeBinding typeBinding = type.resolveBinding();
            if (StringBufferToStringBuilderFixCore.isStringBufferType(typeBinding) && (assignment = ASTNodes.getFirstAncestorOrNull((ASTNode)visited, Assignment.class)) != null && (leftSide = assignment.getLeftHandSide()) instanceof Name && (leftSideBinding = ((Name)leftSide).resolveBinding()) instanceof IVariableBinding && !(leftSideVarBinding = (IVariableBinding)leftSideBinding).isField() && !leftSideVarBinding.isParameter() && !leftSideVarBinding.isRecordComponent()) {
                visited.accept((ASTVisitor)this.fStringBufferFinder);
            }
            return true;
        }

        public boolean visit(EnhancedForStatement visited) {
            Expression forExpression;
            LocalVarChecker localVarChecker;
            SingleVariableDeclaration forParameter = visited.getParameter();
            Type forParmType = forParameter.getType();
            ITypeBinding forParmTypeBinding = forParmType.resolveBinding();
            if (StringBufferToStringBuilderFixCore.isStringBufferType(forParmTypeBinding) && (localVarChecker = new LocalVarChecker((ASTNode)(forExpression = visited.getExpression()))).isValid()) {
                forParameter.accept((ASTVisitor)this.fStringBufferFinder);
                forExpression.accept((ASTVisitor)this.fStringBufferFinder);
            }
            return true;
        }
    }

    public static final class StringBufferFinder
    extends ASTVisitor {
        private final List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fOperations;

        public StringBufferFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations) {
            super(true);
            this.fOperations = operations;
        }

        private void checkType(Type type) {
            ITypeBinding typeBinding;
            if (type instanceof ArrayType) {
                type = ((ArrayType)type).getElementType();
            }
            if ((typeBinding = type.resolveBinding()) != null && typeBinding.getQualifiedName().equals(STRINGBUFFER_CLASS_NAME)) {
                this.fOperations.add(new ChangeStringBufferToStringBuilder(type));
            }
        }

        public boolean visit(VariableDeclarationStatement visited) {
            Type type = visited.getType();
            this.checkType(type);
            return true;
        }

        public boolean visit(MethodInvocation node) {
            ITypeBinding type;
            IMethodBinding methodBinding;
            ITypeBinding returnBinding = node.resolveTypeBinding();
            if (returnBinding != null && StringBufferToStringBuilderFixCore.isStringBufferType(returnBinding) && (methodBinding = node.resolveMethodBinding()) != null && (type = methodBinding.getDeclaringClass()) != null && !type.isFromSource() && !type.getQualifiedName().equals(STRINGBUFFER_CLASS_NAME)) {
                this.fOperations.add(new ChangeStringBufferToStringBuilder(node));
            }
            return true;
        }

        public boolean visit(FieldDeclaration visited) {
            Type type = visited.getType();
            this.checkType(type);
            return true;
        }

        public boolean visit(MethodDeclaration visited) {
            IMethodBinding methodBinding = visited.resolveBinding();
            if (methodBinding == null) {
                return true;
            }
            Type returnType = visited.getReturnType2();
            if (returnType != null) {
                this.checkType(returnType);
            }
            for (Object obj : visited.parameters()) {
                SingleVariableDeclaration parm = (SingleVariableDeclaration)obj;
                Type type = parm.getType();
                this.checkType(type);
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation visited) {
            Type type = visited.getType();
            this.checkType(type);
            return true;
        }

        public boolean visit(CastExpression visited) {
            Type type = visited.getType();
            this.checkType(type);
            return true;
        }

        public boolean visit(ArrayCreation visited) {
            ArrayType type = visited.getType();
            this.checkType((Type)type);
            return true;
        }

        public boolean visit(ParameterizedType visited) {
            List types = visited.typeArguments();
            for (Type type : types) {
                this.checkType(type);
            }
            return true;
        }

        public boolean visit(TypeDeclaration visited) {
            List typeParameters = visited.typeParameters();
            for (TypeParameter typeParameter : typeParameters) {
                List types = typeParameter.typeBounds();
                for (Type type : types) {
                    this.checkType(type);
                }
            }
            Type superClassType = visited.getSuperclassType();
            if (superClassType != null) {
                this.checkType(superClassType);
            }
            if (ASTHelper.isSealedTypeSupportedInAST(visited.getAST())) {
                List permittedTypes = visited.permittedTypes();
                for (Type type : permittedTypes) {
                    this.checkType(type);
                }
            }
            return true;
        }

        public boolean visit(RecordDeclaration visited) {
            List typeParameters = visited.typeParameters();
            for (TypeParameter typeParameter : typeParameters) {
                List types = typeParameter.typeBounds();
                for (Type type : types) {
                    this.checkType(type);
                }
            }
            return true;
        }

        public boolean visit(SingleVariableDeclaration visited) {
            Type type = visited.getType();
            this.checkType(type);
            return true;
        }

        public boolean visit(EnhancedForStatement visited) {
            return true;
        }

        public boolean visit(InstanceofExpression visited) {
            Type type = visited.getRightOperand();
            this.checkType(type);
            return true;
        }

        public boolean visit(MethodRefParameter visited) {
            Type type = visited.getType();
            this.checkType(type);
            return true;
        }

        public boolean visit(MethodRef visited) {
            Name name = visited.getQualifier();
            if (name instanceof SimpleName && name.getFullyQualifiedName().equals(StringBuffer.class.getSimpleName())) {
                this.fOperations.add(new ChangeStringBufferToStringBuilder((SimpleName)name));
            }
            return true;
        }

        public boolean visit(TagElement visited) {
            List fragments = visited.fragments();
            for (ASTNode fragment : fragments) {
                if (!(fragment instanceof SimpleName) || !((SimpleName)fragment).getFullyQualifiedName().equals(StringBuffer.class.getSimpleName())) continue;
                this.fOperations.add(new ChangeStringBufferToStringBuilder((SimpleName)fragment));
            }
            return true;
        }
    }

    public static final class ValidLocalMethodFinder
    extends ASTVisitor {
        private final List<MethodDeclaration> fMethodDeclarations;

        public ValidLocalMethodFinder(List<MethodDeclaration> methodDeclarations) {
            this.fMethodDeclarations = methodDeclarations;
        }

        public boolean visit(MethodDeclaration visited) {
            IMethodBinding methodBinding = visited.resolveBinding();
            if (methodBinding != null) {
                ASTVisitor checkMethodDeclaration = new ASTVisitor(){

                    public boolean visit(MethodInvocation methodInvocation) {
                        ITypeBinding typeBinding;
                        IVariableBinding expVarBinding;
                        IBinding expBinding;
                        IMethodBinding methodInvocationBinding = methodInvocation.resolveMethodBinding();
                        if (methodInvocationBinding == null) {
                            throw new AbortSearchException();
                        }
                        Expression exp = ASTNodes.getUnparenthesedExpression(methodInvocation.getExpression());
                        while (exp instanceof MethodInvocation) {
                            exp = ((MethodInvocation)exp).getExpression();
                        }
                        if (exp instanceof SimpleName && (expBinding = ((SimpleName)exp).resolveBinding()) instanceof IVariableBinding && !(expVarBinding = (IVariableBinding)expBinding).isField() && !expVarBinding.isParameter() && !expVarBinding.isRecordComponent() && StringBufferToStringBuilderFixCore.isStringBufferType(typeBinding = expVarBinding.getType())) {
                            return true;
                        }
                        return this.checkMethodArgs(methodInvocation.arguments(), methodInvocationBinding);
                    }

                    public boolean visit(SuperMethodInvocation superMethodInvocation) {
                        IMethodBinding methodInvocationBinding = superMethodInvocation.resolveMethodBinding();
                        if (methodInvocationBinding == null) {
                            throw new AbortSearchException();
                        }
                        return this.checkMethodArgs(superMethodInvocation.arguments(), methodInvocationBinding);
                    }

                    public boolean visit(ConstructorInvocation constructorInvocation) {
                        IMethodBinding constructorBinding = constructorInvocation.resolveConstructorBinding();
                        if (constructorBinding == null) {
                            throw new AbortSearchException();
                        }
                        return this.checkMethodArgs(constructorInvocation.arguments(), constructorBinding);
                    }

                    public boolean visit(ClassInstanceCreation classInstanceCreation) {
                        IMethodBinding constructorBinding = classInstanceCreation.resolveConstructorBinding();
                        if (constructorBinding == null) {
                            throw new AbortSearchException();
                        }
                        return this.checkMethodArgs(classInstanceCreation.arguments(), constructorBinding);
                    }

                    private boolean checkMethodArgs(List<Expression> methodArgs, IMethodBinding methodInvocationBinding) {
                        CheckNodeForValidReferences checkNode;
                        ITypeBinding methodArgBinding;
                        ITypeBinding[] parameterTypes = methodInvocationBinding.getParameterTypes();
                        int len = methodArgs.size() <= parameterTypes.length ? methodArgs.size() : parameterTypes.length;
                        int i = 0;
                        while (i < len) {
                            methodArgBinding = methodArgs.get(i).resolveTypeBinding();
                            if ((StringBufferToStringBuilderFixCore.isStringBufferType(parameterTypes[i]) || StringBufferToStringBuilderFixCore.isStringBufferType(methodArgBinding) && StringBufferToStringBuilderFixCore.isObjectType(parameterTypes[i])) && !(checkNode = new CheckNodeForValidReferences((ASTNode)methodArgs.get(i), false)).isValid()) {
                                throw new AbortSearchException();
                            }
                            ++i;
                        }
                        if (methodInvocationBinding.isVarargs() && methodArgs.size() > parameterTypes.length) {
                            i = parameterTypes.length;
                            while (i < methodArgs.size()) {
                                methodArgBinding = methodArgs.get(i).resolveTypeBinding();
                                if (StringBufferToStringBuilderFixCore.isStringBufferType(methodArgBinding) && !(checkNode = new CheckNodeForValidReferences((ASTNode)methodArgs.get(i), false)).isValid()) {
                                    throw new AbortSearchException();
                                }
                                ++i;
                            }
                        }
                        return true;
                    }

                    public boolean visit(VariableDeclarationStatement varDeclStatement) {
                        Type varDeclType = varDeclStatement.getType();
                        ITypeBinding varDeclTypeBinding = varDeclType.resolveBinding();
                        if (StringBufferToStringBuilderFixCore.isStringBufferType(varDeclTypeBinding)) {
                            List frags = varDeclStatement.fragments();
                            for (VariableDeclarationFragment frag : frags) {
                                CheckNodeForValidReferences checkNode;
                                Expression initializer = frag.getInitializer();
                                if (initializer == null || (checkNode = new CheckNodeForValidReferences((ASTNode)initializer, true)).isValid()) continue;
                                throw new AbortSearchException();
                            }
                        }
                        return true;
                    }

                    public boolean visit(Assignment assignment) {
                        ITypeBinding assignmentTypeBinding = assignment.resolveTypeBinding();
                        if (StringBufferToStringBuilderFixCore.isStringBufferType(assignmentTypeBinding)) {
                            Expression leftSide = assignment.getLeftHandSide();
                            if (leftSide instanceof ArrayAccess) {
                                while (leftSide instanceof ArrayAccess) {
                                    leftSide = ((ArrayAccess)leftSide).getArray();
                                }
                            }
                            IBinding leftSideBinding = null;
                            if (leftSide instanceof Name) {
                                leftSideBinding = ((Name)leftSide).resolveBinding();
                            } else if (leftSide instanceof SuperFieldAccess) {
                                leftSideBinding = ((SuperFieldAccess)leftSide).resolveFieldBinding();
                            } else if (leftSide instanceof FieldAccess) {
                                leftSideBinding = ((FieldAccess)leftSide).resolveFieldBinding();
                            }
                            if (leftSideBinding != null && leftSideBinding instanceof IVariableBinding) {
                                IVariableBinding leftSideVarBinding = (IVariableBinding)leftSideBinding;
                                CheckNodeForValidReferences checkNode = new CheckNodeForValidReferences((ASTNode)assignment.getRightHandSide(), !leftSideVarBinding.isField() && !leftSideVarBinding.isParameter() && !leftSideVarBinding.isRecordComponent());
                                if (checkNode.isValid()) {
                                    return true;
                                }
                            }
                            throw new AbortSearchException();
                        }
                        return true;
                    }

                    public boolean visit(EnhancedForStatement enhancedFor) {
                        Expression forExpression;
                        LocalVarChecker localVarChecker;
                        SingleVariableDeclaration forParameter = enhancedFor.getParameter();
                        Type forParmType = forParameter.getType();
                        ITypeBinding forParmTypeBinding = forParmType.resolveBinding();
                        if (StringBufferToStringBuilderFixCore.isStringBufferType(forParmTypeBinding) && !(localVarChecker = new LocalVarChecker((ASTNode)(forExpression = enhancedFor.getExpression()))).isValid()) {
                            throw new AbortSearchException();
                        }
                        return true;
                    }

                    public boolean visit(ReturnStatement returnStatement) {
                        MethodDeclaration methodDeclaration;
                        Expression exp = returnStatement.getExpression();
                        if (exp != null && (methodDeclaration = ASTNodes.getFirstAncestorOrNull((ASTNode)returnStatement, MethodDeclaration.class)) != null) {
                            IMethodBinding returnStatementMethodBinding = methodDeclaration.resolveBinding();
                            if (returnStatementMethodBinding != null) {
                                CheckNodeForValidReferences checkNode;
                                ITypeBinding returnStatementTypeBinding = returnStatementMethodBinding.getReturnType();
                                if (StringBufferToStringBuilderFixCore.isStringBufferType(returnStatementTypeBinding) && !(checkNode = new CheckNodeForValidReferences((ASTNode)exp, false)).isValid()) {
                                    throw new AbortSearchException();
                                }
                                return true;
                            }
                            throw new AbortSearchException();
                        }
                        return true;
                    }

                    public boolean visit(FieldAccess fieldAccess) {
                        IVariableBinding fieldBinding = fieldAccess.resolveFieldBinding();
                        if (fieldBinding == null) {
                            throw new AbortSearchException();
                        }
                        return this.checkFieldAccess((ASTNode)fieldAccess, fieldBinding);
                    }

                    public boolean visit(SuperFieldAccess superFieldAccess) {
                        IVariableBinding fieldBinding = superFieldAccess.resolveFieldBinding();
                        if (fieldBinding == null) {
                            throw new AbortSearchException();
                        }
                        return this.checkFieldAccess((ASTNode)superFieldAccess, fieldBinding);
                    }

                    private boolean checkFieldAccess(ASTNode node, IVariableBinding fieldBinding) {
                        ITypeBinding fieldTypeBinding = fieldBinding.getType();
                        if (StringBufferToStringBuilderFixCore.isStringBufferType(fieldTypeBinding)) {
                            ITypeBinding fieldMethodReturnTypeBinding;
                            MethodInvocation parent;
                            IMethodBinding fieldMethodBinding;
                            if (node.getLocationInParent() == MethodInvocation.EXPRESSION_PROPERTY && (fieldMethodBinding = (parent = (MethodInvocation)node.getParent()).resolveMethodBinding()) != null && !StringBufferToStringBuilderFixCore.isStringBufferType(fieldMethodReturnTypeBinding = fieldMethodBinding.getReturnType())) {
                                return true;
                            }
                            Assignment assignment = ASTNodes.getFirstAncestorOrNull(node, Assignment.class);
                            if (assignment != null) {
                                Expression leftSide = assignment.getLeftHandSide();
                                if (leftSide instanceof Name) {
                                    IBinding leftSideBinding = ((Name)leftSide).resolveBinding();
                                    if (leftSideBinding instanceof IVariableBinding) {
                                        IVariableBinding leftSideVarBinding = (IVariableBinding)leftSideBinding;
                                        ITypeBinding leftNameBindingType = leftSideVarBinding.getType();
                                        if (leftNameBindingType == null) {
                                            throw new AbortSearchException();
                                        }
                                        if (!StringBufferToStringBuilderFixCore.isStringBufferType(leftNameBindingType)) {
                                            return true;
                                        }
                                        CheckNodeForValidReferences checkAssignmentValid = new CheckNodeForValidReferences((ASTNode)assignment, !leftSideVarBinding.isParameter());
                                        if (checkAssignmentValid.isValid()) {
                                            return true;
                                        }
                                    }
                                } else {
                                    IVariableBinding leftFieldBinding = null;
                                    if (leftSide instanceof FieldAccess) {
                                        leftFieldBinding = ((FieldAccess)leftSide).resolveFieldBinding();
                                    } else if (leftSide instanceof SuperFieldAccess) {
                                        leftFieldBinding = ((SuperFieldAccess)leftSide).resolveFieldBinding();
                                    }
                                    if (leftFieldBinding == null) {
                                        throw new AbortSearchException();
                                    }
                                    ITypeBinding leftFieldBindingType = leftFieldBinding.getType();
                                    if (!StringBufferToStringBuilderFixCore.isStringBufferType(leftFieldBindingType)) {
                                        return true;
                                    }
                                    CheckNodeForValidReferences checkAssignmentValid = new CheckNodeForValidReferences((ASTNode)assignment, false);
                                    if (checkAssignmentValid.isValid()) {
                                        return true;
                                    }
                                }
                            }
                        }
                        return true;
                    }

                    class CheckNodeForValidReferences {
                        private final ASTNode fASTNode;
                        private final boolean fLocalVarsOnly;

                        public CheckNodeForValidReferences(ASTNode node, boolean localVarsOnly) {
                            this.fASTNode = node;
                            this.fLocalVarsOnly = localVarsOnly;
                        }

                        public boolean isValid() {
                            ASTVisitor visitor = new ASTVisitor(){

                                public boolean visit(FieldAccess visitedField) {
                                    IVariableBinding binding = visitedField.resolveFieldBinding();
                                    if (binding == null) {
                                        throw new AbortSearchException();
                                    }
                                    if (CheckNodeForValidReferences.this.fLocalVarsOnly && visitedField.getLocationInParent() == MethodInvocation.EXPRESSION_PROPERTY) {
                                        MethodInvocation methodInvocation = (MethodInvocation)visitedField.getParent();
                                        IMethodBinding methodInvocationBinding = methodInvocation.resolveMethodBinding();
                                        if (methodInvocationBinding == null) {
                                            throw new AbortSearchException();
                                        }
                                        ITypeBinding methodTypeBinding = methodInvocationBinding.getReturnType();
                                        if (StringBufferToStringBuilderFixCore.isStringBufferType(methodTypeBinding)) {
                                            throw new AbortSearchException();
                                        }
                                    }
                                    return true;
                                }

                                public boolean visit(SuperFieldAccess visitedField) {
                                    IVariableBinding binding = visitedField.resolveFieldBinding();
                                    if (binding == null) {
                                        throw new AbortSearchException();
                                    }
                                    if (CheckNodeForValidReferences.this.fLocalVarsOnly && visitedField.getLocationInParent() == MethodInvocation.EXPRESSION_PROPERTY) {
                                        MethodInvocation methodInvocation = (MethodInvocation)visitedField.getParent();
                                        IMethodBinding methodInvocationBinding = methodInvocation.resolveMethodBinding();
                                        if (methodInvocationBinding == null) {
                                            throw new AbortSearchException();
                                        }
                                        ITypeBinding methodTypeBinding = methodInvocationBinding.getReturnType();
                                        if (StringBufferToStringBuilderFixCore.isStringBufferType(methodTypeBinding)) {
                                            throw new AbortSearchException();
                                        }
                                    }
                                    return true;
                                }

                                public boolean visit(MethodInvocation methodInvocation) {
                                    if (CheckNodeForValidReferences.this.fLocalVarsOnly) {
                                        IMethodBinding methodInvocationBinding = methodInvocation.resolveMethodBinding();
                                        if (methodInvocationBinding == null) {
                                            throw new AbortSearchException();
                                        }
                                        ITypeBinding methodTypeBinding = methodInvocationBinding.getReturnType();
                                        if (StringBufferToStringBuilderFixCore.isStringBufferType(methodTypeBinding)) {
                                            ITypeBinding typeBinding;
                                            IBinding binding;
                                            Expression exp = methodInvocation.getExpression();
                                            if (exp instanceof SimpleName ? (binding = ((SimpleName)exp).resolveBinding()) instanceof IVariableBinding && !((IVariableBinding)binding).isField() && !((IVariableBinding)binding).isParameter() && !((IVariableBinding)binding).isRecordComponent() && StringBufferToStringBuilderFixCore.isStringBufferType(typeBinding = ((IVariableBinding)binding).getType()) : StringBufferToStringBuilderFixCore.isStringBufferType(methodInvocationBinding.getDeclaringClass())) {
                                                return true;
                                            }
                                            throw new AbortSearchException();
                                        }
                                    }
                                    return true;
                                }

                                public boolean visit(CastExpression castExpression) {
                                    Type castType = castExpression.getType();
                                    ITypeBinding typeBinding = castType.resolveBinding();
                                    if (StringBufferToStringBuilderFixCore.isStringBufferType(typeBinding)) {
                                        IBinding binding;
                                        Expression exp = castExpression.getExpression();
                                        if (exp instanceof Name && (binding = ((Name)exp).resolveBinding()) instanceof IVariableBinding) {
                                            IVariableBinding simpleNameVarBinding = (IVariableBinding)binding;
                                            if (!CheckNodeForValidReferences.this.fLocalVarsOnly ? !simpleNameVarBinding.isField() && !simpleNameVarBinding.isParameter() && !simpleNameVarBinding.isRecordComponent() : simpleNameVarBinding.isField() || simpleNameVarBinding.isParameter() || simpleNameVarBinding.isRecordComponent()) {
                                                throw new AbortSearchException();
                                            }
                                        }
                                        throw new AbortSearchException();
                                    }
                                    return true;
                                }

                                public boolean visit(SimpleName simpleName) {
                                    IVariableBinding simpleNameVarBinding;
                                    ITypeBinding simpleNameTypeBinding;
                                    IBinding simpleNameBinding = simpleName.resolveBinding();
                                    if (simpleNameBinding == null) {
                                        throw new AbortSearchException();
                                    }
                                    if (simpleNameBinding instanceof IVariableBinding && StringBufferToStringBuilderFixCore.isStringBufferType(simpleNameTypeBinding = (simpleNameVarBinding = (IVariableBinding)simpleNameBinding).getType())) {
                                        if (simpleName.getLocationInParent() == MethodInvocation.EXPRESSION_PROPERTY) {
                                            MethodInvocation methodInvocation = (MethodInvocation)simpleName.getParent();
                                            IMethodBinding methodInvocationBinding = methodInvocation.resolveMethodBinding();
                                            if (methodInvocationBinding == null) {
                                                throw new AbortSearchException();
                                            }
                                            ITypeBinding methodInvocationReturnType = methodInvocationBinding.getReturnType();
                                            if (!StringBufferToStringBuilderFixCore.isStringBufferType(methodInvocationReturnType)) {
                                                return true;
                                            }
                                        }
                                        if (!CheckNodeForValidReferences.this.fLocalVarsOnly ? !simpleNameVarBinding.isField() && !simpleNameVarBinding.isParameter() && !simpleNameVarBinding.isRecordComponent() : simpleNameVarBinding.isField() || simpleNameVarBinding.isParameter() || simpleNameVarBinding.isRecordComponent()) {
                                            throw new AbortSearchException();
                                        }
                                    }
                                    return true;
                                }
                            };
                            try {
                                this.fASTNode.accept(visitor);
                                return true;
                            }
                            catch (AbortSearchException abortSearchException) {
                                return false;
                            }
                        }
                    }
                };
                try {
                    visited.accept(checkMethodDeclaration);
                    this.fMethodDeclarations.add(visited);
                }
                catch (AbortSearchException abortSearchException) {
                    // empty catch block
                }
            }
            return true;
        }
    }
}

