/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.text;

import com.github.weisj.jsvg.nodes.text.GlyphRun;
import com.github.weisj.jsvg.nodes.text.TextContainer;
import com.github.weisj.jsvg.nodes.text.TextSegment;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StringTextSegment
implements TextSegment {
    private final List<String> codepoints;
    private final TextContainer parent;
    private final int index;
    @Nullable
    GlyphRun currentGlyphRun = null;
    @Nullable
    RenderContext currentRenderContext = null;

    public StringTextSegment(@NotNull TextContainer parent, int index, char[] codepoints) {
        this.parent = parent;
        this.index = index;
        BreakIterator it = BreakIterator.getCharacterInstance();
        it.setText(new CodepointsCharacterIterator(codepoints));
        int start = it.first();
        ArrayList<String> characters = new ArrayList<String>();
        int end = it.next();
        while (end != -1) {
            characters.add(String.copyValueOf(codepoints, start, end - start));
            start = end;
            end = it.next();
        }
        this.codepoints = characters;
    }

    @NotNull
    public @NotNull List<@NotNull String> codepoints() {
        return this.codepoints;
    }

    public boolean isLastSegmentInParent() {
        return this.index == this.parent.children().size() - 1;
    }

    private static final class CodepointsCharacterIterator
    implements CharacterIterator {
        private final char[] codepoints;
        private int index;

        private CodepointsCharacterIterator(char[] codepoints) {
            this.codepoints = codepoints;
        }

        @Override
        public char first() {
            if (this.codepoints.length == 0) {
                return '\uffff';
            }
            this.index = this.getBeginIndex();
            return this.codepoints[this.index];
        }

        @Override
        public char last() {
            if (this.codepoints.length == 0) {
                return '\uffff';
            }
            this.index = this.getEndIndex() - 1;
            return this.codepoints[this.index];
        }

        @Override
        public char current() {
            if (this.index == this.getEndIndex()) {
                return '\uffff';
            }
            return this.codepoints[this.index];
        }

        @Override
        public char next() {
            if (this.index == this.getEndIndex()) {
                return '\uffff';
            }
            return this.codepoints[this.index++];
        }

        @Override
        public char previous() {
            if (this.index == this.getBeginIndex()) {
                return '\uffff';
            }
            return this.codepoints[--this.index];
        }

        @Override
        public char setIndex(int position) {
            if (position < this.getBeginIndex() || position > this.getEndIndex()) {
                throw new IllegalArgumentException("Invalid index");
            }
            this.index = position;
            return this.current();
        }

        @Override
        public int getBeginIndex() {
            return 0;
        }

        @Override
        public int getEndIndex() {
            return this.codepoints.length;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        @NotNull
        public Object clone() {
            CodepointsCharacterIterator it = new CodepointsCharacterIterator(this.codepoints);
            it.index = this.index;
            return it;
        }
    }
}

