/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rcptt.ecl.core.Binding;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.CommandStack;
import org.eclipse.rcptt.ecl.core.ProcInstance;
import org.eclipse.rcptt.ecl.core.SessionListenerManager;
import org.eclipse.rcptt.ecl.internal.core.AbstractRootSession;
import org.eclipse.rcptt.ecl.internal.core.CommandSession;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.internal.core.Pipe;
import org.eclipse.rcptt.ecl.internal.core.ProcInstanceService;
import org.eclipse.rcptt.ecl.internal.core.Process;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;

public abstract class AbstractSession
implements ISession {
    private Map<String, Object> properties = null;

    protected abstract void doExecute(Command var1, ICommandService var2, List<Object> var3, Process var4);

    protected abstract CommandStack getStack();

    public abstract AbstractRootSession getRoot();

    @Override
    public IProcess execute(Command command) throws CoreException {
        return this.execute(command, null, null);
    }

    @Override
    public IProcess execute(Command scriptlet, IPipe in, IPipe out) throws CoreException {
        if (this.isClosed()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        ICommandService svc = scriptlet instanceof ProcInstance ? new ProcInstanceService() : CorePlugin.getScriptletManager().getScriptletService(scriptlet);
        IPipe tinput = in == null ? this.createPipe().close(Status.OK_STATUS) : in;
        IPipe output = out == null ? this.createPipe() : out;
        List<Object> inputContent = CoreUtils.readPipeContent(tinput);
        IPipe input = this.createPipe();
        for (Object o : inputContent) {
            input.write(o);
        }
        input.close(Status.OK_STATUS);
        CommandSession session = new CommandSession(this.getRoot(), new CommandStack(scriptlet, this.getStack()), this);
        Process process = new Process(session, input, output);
        this.doExecute(scriptlet, svc, inputContent, process);
        return process;
    }

    /*
     * Loose catch block
     */
    protected void internalDoExecute(Command scriptlet, ICommandService svc, List<Object> inputContent, Process process) {
        IStatus s = null;
        CommandStack stack = ((AbstractSession)process.getSession()).getStack();
        try {
            try {
                this.resolveBindings(scriptlet, inputContent);
                this.setupInputFeature(scriptlet, inputContent);
                this.checkParams(scriptlet);
                CommandStack.fireEnter(stack);
                SessionListenerManager.beginCommand(scriptlet);
                try {
                    try {
                        s = svc.service(scriptlet, process);
                    }
                    catch (CoreException e) {
                        s = e.getStatus();
                    }
                    catch (Throwable e) {
                        s = CorePlugin.err(e);
                    }
                }
                finally {
                    try {
                        SessionListenerManager.endCommand(scriptlet, s);
                    }
                    catch (Throwable e) {
                        s = CorePlugin.err(e);
                        CorePlugin.log(s);
                    }
                }
            }
            catch (CoreException e) {
                s = e.getStatus();
                CommandStack.fireExit(stack);
                try {
                    process.setStatus(s);
                }
                catch (CoreException ioe) {
                    s = ioe.getStatus();
                    try {
                        process.setStatus(s);
                    }
                    catch (CoreException e2) {
                        CorePlugin.log(e2.getStatus());
                    }
                }
            }
            catch (InterruptedException ie) {
                s = CorePlugin.err(ie);
                CorePlugin.log(s);
                CommandStack.fireExit(stack);
                try {
                    process.setStatus(s);
                }
                catch (CoreException ioe) {
                    s = ioe.getStatus();
                    try {
                        process.setStatus(s);
                    }
                    catch (CoreException e) {
                        CorePlugin.log(e.getStatus());
                    }
                }
            }
            catch (Throwable t) {
                s = CorePlugin.err(t);
                CorePlugin.log(s);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                CommandStack.fireExit(stack);
                try {
                    process.setStatus(s);
                }
                catch (CoreException ioe) {
                    s = ioe.getStatus();
                    try {
                        process.setStatus(s);
                    }
                    catch (CoreException e) {
                        CorePlugin.log(e.getStatus());
                    }
                }
            }
        }
        finally {
            CommandStack.fireExit(stack);
            try {
                process.setStatus(s);
            }
            catch (CoreException ioe) {
                s = ioe.getStatus();
                try {
                    process.setStatus(s);
                }
                catch (CoreException e) {
                    CorePlugin.log(e.getStatus());
                }
            }
        }
    }

    protected void setupInputFeature(Command scriptlet, List<Object> inputContent) throws CoreException {
        EStructuralFeature inputFeature = null;
        for (EStructuralFeature feature : CoreUtils.getFeatures(scriptlet.eClass())) {
            if (feature.getEAnnotation("http://www.eclipse.org/ecl/input") == null || scriptlet.eIsSet(feature)) continue;
            if (inputFeature == null) {
                inputFeature = feature;
                continue;
            }
            Status status = new Status(4, "org.eclipse.rcptt.ecl.core", "Command has more than one input param");
            throw new CoreException((IStatus)status);
        }
        if (inputFeature != null) {
            CoreUtils.featureSafeSet(scriptlet, inputFeature, inputContent);
        }
    }

    protected void resolveBindings(Command scriptlet, List<Object> inputContent) throws CoreException, InterruptedException {
        for (Binding binding : scriptlet.getBindings()) {
            EStructuralFeature feature = binding.getFeature();
            Command command = binding.getCommand();
            IPipe in = this.createPipe();
            for (Object o : inputContent) {
                in.write(o);
            }
            in.close(Status.OK_STATUS);
            IPipe out = this.createPipe();
            IProcess process = this.execute(command, in, out);
            IStatus status = process.waitFor();
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            CoreUtils.featureSafeSet(scriptlet, feature, CoreUtils.readPipeContent(out));
        }
    }

    protected void checkParams(Command scriptlet) throws CoreException {
        for (EStructuralFeature feature : scriptlet.eClass().getEStructuralFeatures()) {
            CoreUtils.checkBounds(feature, scriptlet.eGet(feature));
        }
    }

    @Override
    public IPipe createPipe() {
        return new Pipe();
    }

    @Override
    public synchronized void putProperty(String key, Object value) {
        if (value == null) {
            if (this.properties != null) {
                this.properties.remove(key);
            }
        } else {
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>();
            }
            this.properties.put(key, value);
        }
    }

    @Override
    public synchronized Object getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }
}

