/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.wizards.plain;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rcptt.core.Scenarios;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.persistence.PersistenceManager;
import org.eclipse.rcptt.core.persistence.plain.IPlainConstants;
import org.eclipse.rcptt.core.persistence.plain.PlainTextPersistenceModel;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.wizards.plain.DestinationsBox;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Widget;

public class Q7PortableFormatExportPage
extends WizardPage
implements IPlainConstants {
    private DestinationsBox destinations;
    private DataBindingContext dbc = new DataBindingContext();
    private ITestCase element;
    private PlainTextPersistenceModel tempModel = null;
    private WritableValue<String> previewValue = new WritableValue((Object)"", String.class);

    protected Q7PortableFormatExportPage(String pageName, ITestCase element) {
        super(pageName);
        this.setDescription("Select the destination where RCPTT should store exported content");
        this.setTitle("RCPTT Portable Format");
        this.element = element;
    }

    public void createControl(Composite parent) {
        Composite cp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(cp);
        Group preview = new Group(cp, 0);
        preview.setText("Preview");
        GridDataFactory.fillDefaults().hint(200, 200).grab(true, true).applyTo((Control)preview);
        GridLayoutFactory.swtDefaults().applyTo((Composite)preview);
        StyledText text = new StyledText((Composite)preview, 2824);
        text.setCaret(null);
        FontData dt = new FontData("monospace", 10, 0);
        Font font = new Font((Device)text.getDisplay(), dt);
        text.setFont(font);
        text.addDisposeListener(ignored -> font.dispose());
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)text), this.previewValue);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)text);
        this.destinations = new DestinationsBox(this.dbc){

            @Override
            protected String getFileTitle() {
                return "Export to File";
            }

            @Override
            protected String getClipboardTitle() {
                return "Export to Clipboard";
            }

            @Override
            protected int getFileKind() {
                return 8192;
            }
        };
        this.destinations.create(cp);
        this.setControl((Control)cp);
        this.updateExport();
        this.destinations.addChangeListener(new Runnable(){

            @Override
            public void run() {
                DestinationsBox.Selection kind = Q7PortableFormatExportPage.this.destinations.getKind();
                switch (kind) {
                    case Clipboard: {
                        Q7PortableFormatExportPage.this.setErrorMessage(null);
                        Q7PortableFormatExportPage.this.setPageComplete(true);
                        break;
                    }
                    case Filesystem: {
                        String path = Q7PortableFormatExportPage.this.destinations.getFileSystemPath();
                        if (path == null || path.trim().length() == 0) {
                            Q7PortableFormatExportPage.this.setErrorMessage("Please specify correct file name to export testcase");
                            Q7PortableFormatExportPage.this.setPageComplete(false);
                            break;
                        }
                        if (new File(path).isDirectory()) {
                            Q7PortableFormatExportPage.this.setErrorMessage("Please specify correct file name to export ");
                            Q7PortableFormatExportPage.this.setPageComplete(false);
                            break;
                        }
                        if (!new File(path).getParentFile().exists()) {
                            Q7PortableFormatExportPage.this.setErrorMessage("Please specify correct folder to store file in");
                            Q7PortableFormatExportPage.this.setPageComplete(false);
                            break;
                        }
                        Q7PortableFormatExportPage.this.setPageComplete(true);
                        Q7PortableFormatExportPage.this.setErrorMessage(null);
                        break;
                    }
                }
            }
        });
    }

    private void saveResourceWithUpdate(Resource element, OutputStream store) {
        try {
            XMIResourceImpl tempResource = new XMIResourceImpl(element.getURI());
            EList contents = element.getContents();
            Collection copyAll = EcoreUtil.copyAll((Collection)contents);
            tempResource.getContents().addAll(copyAll);
            for (EObject eObject : copyAll) {
                if (eObject instanceof Scenario) {
                    ((Scenario)eObject).setContent(null);
                }
                if (!(eObject instanceof NamedElement)) continue;
                ((NamedElement)eObject).setDescription(null);
            }
            tempResource.save(store, PersistenceManager.getOptions());
        }
        catch (IOException e) {
            RcpttPlugin.log((Throwable)e);
        }
    }

    private void updateExport() {
        if (this.tempModel != null) {
            this.tempModel.dispose();
        }
        try {
            XMIResourceImpl res = new XMIResourceImpl();
            Scenario elementCopy = (Scenario)EcoreUtil.copy((EObject)this.element.getNamedElement());
            res.getContents().add((Object)elementCopy);
            this.tempModel = new PlainTextPersistenceModel((Resource)res);
            IPersistenceModel model = this.element.getPersistenceModel();
            this.tempModel.copyFrom(model);
            this.tempModel.updateAttributes();
            Script ecl = Scenarios.getEcl((ITestCase)this.element);
            elementCopy.setContent((EObject)ecl);
            PersistenceManager.getInstance().updateScenarioContent((Resource)res, (IPersistenceModel)this.tempModel);
            OutputStream store = this.tempModel.store(".q7.content");
            this.saveResourceWithUpdate((Resource)res, store);
            store.close();
            HashSet ctxs = new HashSet();
            RcpttCore.getInstance().findAllContexts((IQ7NamedElement)this.element, ctxs);
            for (IContext iContext : ctxs) {
                OutputStream stream = this.tempModel.store("/contexts/" + iContext.getID());
                try {
                    FileUtil.copy((InputStream)new BufferedInputStream(((IFile)iContext.getResource()).getContents()), (OutputStream)stream);
                }
                catch (CoreException e) {
                    Q7UIPlugin.log(e);
                }
            }
            HashSet verifications = new HashSet();
            RcpttCore.getInstance().findAllVerifications((IQ7NamedElement)this.element, verifications);
            for (IVerification v : verifications) {
                OutputStream stream = this.tempModel.store("/verifications/" + v.getID());
                try {
                    FileUtil.copy((InputStream)new BufferedInputStream(((IFile)v.getResource()).getContents()), (OutputStream)stream);
                }
                catch (CoreException e) {
                    Q7UIPlugin.log(e);
                }
            }
            File temporaty = this.tempModel.storeToTemporaty();
            String content = new String(FileUtil.getStreamContent((InputStream)new BufferedInputStream(new FileInputStream(temporaty))), "utf-8");
            this.previewValue.setValue((Object)content);
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        catch (IOException e) {
            Q7UIPlugin.log(e);
        }
    }

    public void dispose() {
        this.dbc.dispose();
        super.dispose();
    }

    public boolean finish() {
        DestinationsBox.Selection kind = this.destinations.getKind();
        switch (kind) {
            case Filesystem: {
                try {
                    File f = new File(this.destinations.getFileSystemPath());
                    BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(f));
                    OutputStreamWriter wr = new OutputStreamWriter((OutputStream)bout, "utf-8");
                    wr.write((String)this.previewValue.getValue());
                    wr.close();
                    FileUtil.safeClose((Closeable)bout);
                    break;
                }
                catch (Exception e) {
                    Q7UIPlugin.log(e);
                    return false;
                }
            }
            case Clipboard: {
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                clipboard.setContents(new Object[]{this.previewValue.getValue()}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        }
        return true;
    }
}

