/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.commons.listcelleditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.commons.listcelleditor.StringWrapper;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ListControl
extends Composite {
    private final Tree tree;
    private final TreeViewer viewer;
    private final List<StringWrapper> values;
    private final boolean readOnly;
    private FilterEditor filterEditor;
    private Composite buttonsComposite;

    public ListControl(Composite parent, int style) {
        this(parent, style, false, new ArrayList<StringWrapper>());
    }

    public ListControl(Composite parent, int style, boolean createButtons, List<StringWrapper> values) {
        super(parent, 0);
        this.readOnly = (style & 8) != 0;
        GridLayout layout = new GridLayout(createButtons ? 2 : 1, false);
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        this.setLayout((Layout)layout);
        this.tree = new Tree((Composite)this, style | 0x200 | 2);
        this.viewer = new TreeViewer(this.tree);
        this.values = values;
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    List list = (List)inputElement;
                    return list.toArray();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof List;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }
        });
        this.viewer.setInput(values);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 150;
        this.tree.setLayoutData((Object)gridData);
        if (this.readOnly) {
            return;
        }
        Menu menu = new Menu((Control)this.tree);
        this.filterEditor = new FilterEditor(this.tree);
        this.filterEditor.grabHorizontal = true;
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ListControl.this.filterEditor.closeEditor(false);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ListControl.this.doChange(ListControl.this.filterEditor);
            }
        });
        MenuItem addItem = new MenuItem(menu, 8);
        addItem.setText(Messages.ListControl_Add);
        addItem.addSelectionListener((SelectionListener)new AddAdapter(this.filterEditor));
        final MenuItem changeFilterItem = new MenuItem(menu, 8);
        changeFilterItem.setText(Messages.ListControl_Change);
        changeFilterItem.addSelectionListener((SelectionListener)new ChangeAdapter(this.filterEditor));
        final MenuItem deleteItem = new MenuItem(menu, 8);
        deleteItem.setText(Messages.ListControl_Delete);
        deleteItem.addSelectionListener((SelectionListener)new DeleteAdapter());
        deleteItem.setEnabled(false);
        changeFilterItem.setEnabled(false);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    changeFilterItem.setEnabled(false);
                    deleteItem.setEnabled(false);
                } else if (sel.size() > 1) {
                    changeFilterItem.setEnabled(false);
                    deleteItem.setEnabled(true);
                } else {
                    changeFilterItem.setEnabled(true);
                    deleteItem.setEnabled(true);
                }
            }
        });
        if (createButtons) {
            this.buttonsComposite = new Composite((Composite)this, 0);
            this.buttonsComposite.setLayoutData((Object)new GridData(16384, 128, false, true));
            FillLayout fl = new FillLayout(512);
            fl.spacing = 5;
            this.buttonsComposite.setLayout((Layout)fl);
            Button addItemb = new Button(this.buttonsComposite, 8);
            addItemb.setText(Messages.ListControl_Add);
            addItemb.addSelectionListener((SelectionListener)new AddAdapter(this.filterEditor));
            final Button changeFilterItemb = new Button(this.buttonsComposite, 8);
            changeFilterItemb.setText(Messages.ListControl_Change);
            changeFilterItemb.addSelectionListener((SelectionListener)new ChangeAdapter(this.filterEditor));
            final Button deleteItemb = new Button(this.buttonsComposite, 8);
            deleteItemb.setText(Messages.ListControl_Delete);
            deleteItemb.addSelectionListener((SelectionListener)new DeleteAdapter());
            deleteItemb.setEnabled(false);
            changeFilterItemb.setEnabled(false);
            Button clear = new Button(this.buttonsComposite, 8);
            clear.setText(Messages.ListControl_Clear);
            clear.addSelectionListener((SelectionListener)new ClearAdapter());
            clear.setEnabled(true);
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    if (sel.isEmpty()) {
                        changeFilterItemb.setEnabled(false);
                        deleteItemb.setEnabled(false);
                    } else if (sel.size() > 1) {
                        changeFilterItemb.setEnabled(false);
                        deleteItemb.setEnabled(true);
                    } else {
                        changeFilterItemb.setEnabled(true);
                        deleteItemb.setEnabled(true);
                    }
                }
            });
        }
        this.tree.setMenu(menu);
    }

    public List<StringWrapper> getValues() {
        return this.values;
    }

    public void update() {
        this.viewer.setSelection((ISelection)new StructuredSelection(Collections.EMPTY_LIST));
        this.viewer.refresh(true);
    }

    private void doAddFilter(FilterEditor filterEditor) {
        StringWrapper value = new StringWrapper();
        this.values.add(value);
        this.viewer.refresh();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)value));
        filterEditor.startEditing();
    }

    private void doChange(FilterEditor filterEditor) {
        filterEditor.startEditing();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Control[] childs = this.buttonsComposite.getChildren();
        int i = 0;
        while (i < childs.length) {
            childs[i].setEnabled(enabled);
            ++i;
        }
    }

    private final class AddAdapter
    extends SelectionAdapter {
        private final FilterEditor filterEditor;

        private AddAdapter(FilterEditor filterEditor) {
            this.filterEditor = filterEditor;
        }

        public void widgetSelected(SelectionEvent e) {
            ListControl.this.viewer.cancelEditing();
            ListControl.this.doAddFilter(this.filterEditor);
        }
    }

    private final class ChangeAdapter
    extends SelectionAdapter {
        private final FilterEditor filterEditor;

        private ChangeAdapter(FilterEditor filterEditor) {
            this.filterEditor = filterEditor;
        }

        public void widgetSelected(SelectionEvent e) {
            ListControl.this.doChange(this.filterEditor);
        }
    }

    private final class ClearAdapter
    extends SelectionAdapter {
        private ClearAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            ListControl.this.filterEditor.closeEditor();
            ListControl.this.values.clear();
            ListControl.this.viewer.refresh();
        }
    }

    private final class DeleteAdapter
    extends SelectionAdapter {
        private DeleteAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.delete(true);
        }

        public void delete(boolean closeEditor) {
            IStructuredSelection selection = (IStructuredSelection)ListControl.this.viewer.getSelection();
            for (Object elem : selection) {
                ListControl.this.values.remove(elem);
            }
            if (closeEditor) {
                ListControl.this.filterEditor.closeEditor();
            }
            ListControl.this.viewer.refresh();
        }
    }

    private final class FilterEditor
    extends TreeEditor {
        private StringWrapper text;
        private Text valueEditor;

        private FilterEditor(Tree tree) {
            super(tree);
        }

        public void startEditing() {
            TreeItem[] selection;
            Control oldEditor = this.getEditor();
            if (oldEditor != null) {
                oldEditor.dispose();
            }
            if ((selection = ListControl.this.tree.getSelection()) == null || selection.length < 1) {
                return;
            }
            this.text = (StringWrapper)((IStructuredSelection)ListControl.this.viewer.getSelection()).getFirstElement();
            TreeItem item = selection[0];
            if (item == null) {
                return;
            }
            this.valueEditor = new Text((Composite)ListControl.this.tree, 0);
            this.valueEditor.setText(item.getText());
            this.valueEditor.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent event) {
                    switch (event.detail) {
                        case 4: {
                            FilterEditor.this.applyChanges();
                        }
                        case 2: {
                            FilterEditor.this.closeEditor();
                            event.doit = true;
                            event.detail = 0;
                        }
                    }
                }
            });
            this.valueEditor.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    FilterEditor.this.applyChanges();
                }
            });
            this.valueEditor.selectAll();
            this.valueEditor.setFocus();
            this.setEditor((Control)this.valueEditor, item);
        }

        private void applyChanges() {
            this.text.setString(this.valueEditor.getText());
            ListControl.this.viewer.refresh((Object)this.text);
            ListControl.this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.text));
        }

        private void closeEditor(boolean changeSelection) {
            this.setEditor(null, null);
            if (this.valueEditor != null) {
                this.valueEditor.dispose();
            }
            if (this.text != null && this.text.getString() != null) {
                if (this.text.getString().trim().length() == 0) {
                    new DeleteAdapter().delete(false);
                } else if (changeSelection) {
                    ListControl.this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.text));
                }
                this.text = null;
            }
        }

        private void closeEditor() {
            this.closeEditor(true);
        }
    }
}

