/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.multiaut;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.rcptt.core.ecl.core.model.ExecutionPhase;
import org.eclipse.rcptt.core.launching.events.AutEvent;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.ecl.debug.core.DebuggerBaseTransport;
import org.eclipse.rcptt.ecl.debug.core.DebuggerTransport;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.internal.launching.ExecutionSession;
import org.eclipse.rcptt.internal.launching.PrepareExecutionWrapper;
import org.eclipse.rcptt.internal.launching.Q7LaunchManager;
import org.eclipse.rcptt.internal.launching.Q7Process;
import org.eclipse.rcptt.internal.launching.Q7TestLaunch;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutLaunchListener;
import org.eclipse.rcptt.launching.AutLaunchState;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.launching.IQ7Launch;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.launching.TestCaseDebugger;
import org.eclipse.rcptt.launching.multiaut.LaunchStoreEntry;
import org.eclipse.rcptt.launching.multiaut.MultiAutLaunchPlugin;
import org.eclipse.rcptt.launching.multiaut.ResolvedEntry;

public class MultiAutLaunchDelegate
extends LaunchConfigurationDelegate
implements IQ7Launch {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        List<ResolvedEntry> entries = this.resolveEntries(configuration);
        if (entries.isEmpty()) {
            throw new CoreException(MultiAutLaunchPlugin.errStatus("Nothing to launch", new Object[0]));
        }
        ArrayList<IQ7NamedElement> elements = new ArrayList<IQ7NamedElement>();
        HashMap<Aut, AutLaunch> autLaunches = new HashMap<Aut, AutLaunch>();
        HashMap<Aut, Q7Process> processes = new HashMap<Aut, Q7Process>();
        ArrayList<Executable> executables = new ArrayList<Executable>();
        Q7TestLaunch q7launch = (Q7TestLaunch)launch;
        for (ResolvedEntry entry : entries) {
            AutLaunch autLaunch = this.getLaunch(entry.aut, monitor);
            elements.add(entry.element);
            autLaunches.put(entry.aut, autLaunch);
            Q7Process q7process = new Q7Process(launch, autLaunch, this::createDebugTransport);
            processes.put(entry.aut, q7process);
            Q7LaunchManager.ExecutableFactory f = new Q7LaunchManager.ExecutableFactory(autLaunch, null, q7process.getDebugger());
            Executable[] testExecs = f.map(new IQ7NamedElement[]{entry.element}, null, autLaunch.getCapability());
            int i = 0;
            while (i < testExecs.length) {
                Executable e = testExecs[i];
                if (e instanceof PrepareExecutionWrapper) {
                    testExecs[i] = new MultiAutPrepareExecutionWrapper((PrepareExecutionWrapper)e, entry.restart);
                }
                ++i;
            }
            executables.addAll(Arrays.asList(testExecs));
        }
        IQ7NamedElement[] elementArray = elements.toArray(new IQ7NamedElement[elements.size()]);
        Q7Launcher.setMappedResources((ILaunchConfiguration)configuration, (IQ7NamedElement[])elementArray);
        MultiAutExecutionSession session = new MultiAutExecutionSession(launch.getLaunchConfiguration().getName(), executables.toArray(new Executable[executables.size()]), autLaunches.values(), q7launch);
        int maxEntries = Q7LaunchManager.getInstance().getMaxHistoryEntries();
        IExecutionSession[] prevSessions = Q7LaunchManager.getInstance().getExecutionSessions();
        int i = 0;
        while (i <= prevSessions.length - maxEntries) {
            Q7LaunchManager.getInstance().removeExecutionSession(prevSessions[i]);
            ++i;
        }
        for (AutLaunch autLaunch : autLaunches.values()) {
            if (Q7LaunchManager.getInstance().cancelDebugExecution(autLaunch, null)) continue;
            launch.terminate();
            return;
        }
        q7launch.setSession((IExecutionSession)session);
        String launchId = launch.getLaunchConfiguration().getName();
        Q7LaunchManager.getInstance().execute(launchId, (ExecutionSession)session, (Runnable)((Object)new MultiAutSessionRunnable(launchId, session, processes.values())));
    }

    private DebuggerTransport createDebugTransport(String host, Integer port) {
        try {
            return DebuggerBaseTransport.create((int)port, (String)host);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private AutLaunch getLaunch(Aut aut, IProgressMonitor m) throws CoreException {
        AutLaunch result = aut.getActiveLaunch();
        if (result == null) {
            result = aut.launch(m);
        }
        return new ProxyLaunch(result);
    }

    private List<ResolvedEntry> resolveEntries(ILaunchConfiguration configuration) {
        ArrayList<ResolvedEntry> entries = new ArrayList<ResolvedEntry>();
        LaunchStoreEntry[] launchStoreEntryArray = LaunchStoreEntry.entriesFromConfig(configuration);
        int n = launchStoreEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            LaunchStoreEntry entry = launchStoreEntryArray[n2];
            ResolvedEntry resolved = ResolvedEntry.resolve(entry);
            if (!resolved.isOK()) {
                MultiAutLaunchPlugin.logErr("Ignored invalid test entry stored in launch config '%s'", configuration.getName());
            } else {
                entries.add(resolved);
            }
            ++n2;
        }
        return entries;
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new Q7TestLaunch(configuration, mode);
    }

    private static class MultiAutExecutionSession
    extends ExecutionSession {
        private Set<AutLaunch> auts;

        public MultiAutExecutionSession(String name, Executable[] executables, Collection<AutLaunch> auts, Q7TestLaunch q7launch) {
            super(name, executables, null, q7launch);
            this.auts = new HashSet<AutLaunch>(auts);
        }

        public void dispose() {
            super.dispose();
            this.auts.clear();
        }

        public boolean isDebugging(AutLaunch aut) {
            return this.isRunning() && this.auts.contains(aut);
        }
    }

    private static class MultiAutPrepareExecutionWrapper
    extends PrepareExecutionWrapper {
        private boolean restartAut;
        private ProxyLaunch launch;

        public MultiAutPrepareExecutionWrapper(PrepareExecutionWrapper source, boolean restartAut) throws ModelException {
            super(source.getAut(), source.getExecutable());
            this.restartAut = restartAut;
            this.launch = (ProxyLaunch)this.getAut();
        }

        public IStatus execute() throws InterruptedException {
            if (this.restartAut) {
                try {
                    this.launch.restart();
                }
                catch (CoreException e) {
                    MultiAutLaunchPlugin.getDefault().getLog().log(e.getStatus());
                    throw new InterruptedException("Couldn't restart AUT");
                }
            }
            return super.execute();
        }
    }

    private static class MultiAutSessionRunnable
    extends Q7LaunchManager.SessionRunnable {
        private Set<Q7Process> processes;

        public MultiAutSessionRunnable(String launchId, ExecutionSession session, Collection<Q7Process> processes) {
            super(launchId, session, null);
            this.processes = new HashSet<Q7Process>(processes);
        }

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent event = debugEventArray[n2];
                if (event.getKind() == 8 && this.processes.contains(event.getSource())) {
                    Q7LaunchManager.getInstance().stop(RcpttPlugin.createStatus((String)("One of multiple auts " + String.valueOf(event.getSource()) + " was terminated.")));
                }
                ++n2;
            }
        }
    }

    private static class ProxyLaunch
    implements AutLaunch {
        private AutLaunch launch;

        public void restart() throws CoreException {
            this.launch.terminate();
            this.launch = this.launch.getAut().launch((IProgressMonitor)new NullProgressMonitor());
        }

        public ProxyLaunch(AutLaunch launch) {
            this.launch = launch;
        }

        public String getId() {
            return this.launch.getId();
        }

        public Aut getAut() {
            return this.launch.getAut();
        }

        public AutLaunchState getState() {
            return this.launch.getState();
        }

        public ILaunch getLaunch() {
            return this.launch.getLaunch();
        }

        public void addListener(AutLaunchListener listener) {
            this.launch.addListener(listener);
        }

        public void removeListener(AutLaunchListener listener) {
            this.launch.removeListener(listener);
        }

        public Object execute(Command command) throws CoreException, InterruptedException {
            return this.launch.execute(command);
        }

        public Object execute(Command command, long timeout) throws CoreException, InterruptedException {
            return this.launch.execute(command, timeout);
        }

        public Object execute(Command command, long timeout, IProgressMonitor monitor) throws CoreException, InterruptedException {
            return this.launch.execute(command, timeout, monitor);
        }

        public void run(IQ7NamedElement test, long timeout, IProgressMonitor monitor, ExecutionPhase phase) throws CoreException {
            this.launch.run(test, timeout, monitor, phase);
        }

        public void debug(IQ7NamedElement test, IProgressMonitor monitor, TestCaseDebugger debugger, ExecutionPhase phase) throws CoreException {
            this.launch.debug(test, monitor, debugger, phase);
        }

        public void execute(Script script, long timeout, IProgressMonitor monitor) throws CoreException {
            this.launch.execute(script, timeout, monitor);
        }

        public void ping() throws CoreException, InterruptedException {
            this.launch.ping();
        }

        public void waitForRestart(IProgressMonitor monitor) throws CoreException {
            this.launch.waitForRestart(monitor);
        }

        public void shutdown() {
            this.launch.shutdown();
        }

        public void terminate() {
            this.launch.terminate();
        }

        public void cancelTestExecution() {
            this.launch.cancelTestExecution();
        }

        public void resetState() {
            this.launch.resetState();
        }

        public void handleAutEvent(AutEvent autEvent) {
            this.launch.handleAutEvent(autEvent);
        }

        public String getCapability() {
            return this.launch.getCapability();
        }
    }
}

