/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.multiaut.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.search.AllProjectScope;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.multiaut.LaunchStoreEntry;
import org.eclipse.rcptt.launching.multiaut.ui.AUTLabelProvider;
import org.eclipse.rcptt.launching.multiaut.ui.LaunchUIEntry;
import org.eclipse.rcptt.launching.multiaut.ui.MultiAutContentProvider;
import org.eclipse.rcptt.launching.multiaut.ui.MultiAutLabelProvider;
import org.eclipse.rcptt.launching.multiaut.ui.SelectAutDialog;
import org.eclipse.rcptt.ui.controls.TestSuiteButtonsPanel;
import org.eclipse.rcptt.ui.launching.aut.AutContentProvider;
import org.eclipse.rcptt.ui.launching.aut.AutElement;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class MultiAutLaunchTab
extends AbstractLaunchConfigurationTab {
    private TableViewer entriesViewer;
    private List<LaunchUIEntry> entries = new ArrayList<LaunchUIEntry>();
    private Button up;
    private Button down;
    private Button setAut;
    private Button remove;

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(content);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).applyTo((Control)content);
        Composite tableContainer = new Composite(content, 0);
        GridLayoutFactory.swtDefaults().applyTo(tableContainer);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).applyTo((Control)tableContainer);
        this.entriesViewer = new TableViewer(tableContainer);
        ColumnManager columns = new ColumnManager(this.entriesViewer);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).hint(1, 1).applyTo(this.entriesViewer.getControl());
        TableViewerColumn testColumn = columns.add("Test");
        TableViewerColumn autColumn = columns.add("AUT");
        TableViewerColumn restartColumn = columns.add("Restart");
        restartColumn.getColumn().setToolTipText("Whether to restart AUT before test case");
        this.entriesViewer.getTable().setHeaderVisible(true);
        this.entriesViewer.getTable().setLinesVisible(true);
        this.entriesViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiAutLaunchTab.this.updateButtons();
            }
        });
        Composite buttons = new Composite(content, 0);
        GridDataFactory.swtDefaults().align(0x1000008, 4).grab(false, true).applyTo((Control)buttons);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(buttons);
        Button add = new Button(buttons, 8);
        add.setText("Add test...");
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiAutLaunchTab.this.addTestCase();
            }
        });
        this.remove = new Button(buttons, 8);
        this.remove.setText("Remove");
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiAutLaunchTab.this.removeSelectedTests();
            }
        });
        this.setAut = new Button(buttons, 8);
        this.setAut.setText("Set AUT...");
        this.setAut.setToolTipText("Set AUT for selected test cases");
        this.setAut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiAutLaunchTab.this.setAut();
            }
        });
        this.up = new Button(buttons, 8);
        this.up.setText("Move up");
        this.up.setToolTipText("Move selected test up");
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiAutLaunchTab.this.moveUp();
            }
        });
        this.down = new Button(buttons, 8);
        this.down.setText("Move down");
        this.down.setToolTipText("Move selected test down");
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiAutLaunchTab.this.moveDown();
            }
        });
        GridDataFactory buttonsFactory = GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false);
        buttonsFactory.applyTo((Control)add);
        buttonsFactory.applyTo((Control)this.remove);
        buttonsFactory.applyTo((Control)this.setAut);
        buttonsFactory.applyTo((Control)this.up);
        buttonsFactory.applyTo((Control)this.down);
        this.entriesViewer.setContentProvider((IContentProvider)new MultiAutContentProvider());
        this.entriesViewer.setLabelProvider((IBaseLabelProvider)new MultiAutLabelProvider());
        this.entriesViewer.setInput(this.entries);
        testColumn.getColumn().pack();
        autColumn.getColumn().pack();
        restartColumn.getColumn().pack();
        restartColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.entriesViewer){

            protected void setValue(Object element, Object value) {
                ((LaunchUIEntry)element).restart = (Boolean)value;
                MultiAutLaunchTab.this.entriesViewer.refresh(element);
                MultiAutLaunchTab.this.updateLaunchConfigurationDialog();
            }

            protected Object getValue(Object element) {
                return ((LaunchUIEntry)element).restart;
            }

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)MultiAutLaunchTab.this.entriesViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        autColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.entriesViewer){

            protected void setValue(Object element, Object value) {
                ((LaunchUIEntry)element).aut = ((AutElement)value).getAut();
                MultiAutLaunchTab.this.entriesViewer.refresh(element);
                MultiAutLaunchTab.this.updateLaunchConfigurationDialog();
            }

            protected Object getValue(Object element) {
                LaunchUIEntry entry = (LaunchUIEntry)element;
                return entry.aut == null ? null : new AutElement(entry.aut);
            }

            protected CellEditor getCellEditor(Object element) {
                ComboBoxViewerCellEditor result = new ComboBoxViewerCellEditor((Composite)MultiAutLaunchTab.this.entriesViewer.getTable());
                result.setContentProvider((IStructuredContentProvider)new AutContentProvider());
                result.setLabelProvider((IBaseLabelProvider)new AUTLabelProvider());
                result.setInput(new Object());
                return result;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.setControl((Control)content);
        this.refreshViewer();
    }

    protected void moveDown() {
        LaunchUIEntry entry = (LaunchUIEntry)((IStructuredSelection)this.entriesViewer.getSelection()).getFirstElement();
        int index = this.entries.indexOf(entry);
        Collections.swap(this.entries, index, index + 1);
        this.refreshViewer();
        this.entriesViewer.setSelection((ISelection)new StructuredSelection((Object)entry), true);
    }

    protected void moveUp() {
        LaunchUIEntry entry = (LaunchUIEntry)((IStructuredSelection)this.entriesViewer.getSelection()).getFirstElement();
        int index = this.entries.indexOf(entry);
        Collections.swap(this.entries, index - 1, index);
        this.refreshViewer();
        this.entriesViewer.setSelection((ISelection)new StructuredSelection((Object)entry), true);
    }

    private void setAut() {
        Aut aut = SelectAutDialog.selectAut(this.getShell());
        if (aut == null) {
            return;
        }
        Object[] objectArray = ((IStructuredSelection)this.entriesViewer.getSelection()).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object entry = objectArray[n2];
            ((LaunchUIEntry)entry).aut = aut;
            ++n2;
        }
        this.refreshViewer();
    }

    private void updateButtons() {
        int[] selectionIndices = this.entriesViewer.getTable().getSelectionIndices();
        this.up.setEnabled(selectionIndices.length == 1 && selectionIndices[0] > 0);
        this.down.setEnabled(selectionIndices.length == 1 && selectionIndices[0] < this.entries.size() - 1);
        this.setAut.setEnabled(selectionIndices.length > 0);
        this.remove.setEnabled(selectionIndices.length > 0);
    }

    private void addTestCase() {
        IQ7NamedElement[] selected = TestSuiteButtonsPanel.selectTestCase((ISearchScope)new AllProjectScope(), Collections.emptyList(), (boolean)false);
        boolean changed = false;
        IQ7NamedElement[] iQ7NamedElementArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement element = iQ7NamedElementArray[n2];
            LaunchUIEntry uiEntry = LaunchUIEntry.fromNamedElement(element);
            if (uiEntry != null) {
                this.entries.add(uiEntry);
                changed = true;
            }
            ++n2;
        }
        if (changed) {
            this.refreshViewer();
        }
    }

    private void removeSelectedTests() {
        IStructuredSelection selection = (IStructuredSelection)this.entriesViewer.getSelection();
        boolean changed = false;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.entries.remove(element);
            changed = true;
            ++n2;
        }
        if (changed) {
            this.refreshViewer();
        }
    }

    private void refreshViewer() {
        this.entriesViewer.refresh();
        this.updateButtons();
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.configToUI(LaunchStoreEntry.entriesFromConfig((ILaunchConfiguration)configuration));
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        LaunchStoreEntry.entriesToConfig((LaunchStoreEntry[])this.entriesFromUI(), (ILaunchConfigurationWorkingCopy)configuration);
    }

    public String getName() {
        return "Test Cases";
    }

    private void configToUI(LaunchStoreEntry[] entries) {
        this.entries.clear();
        LaunchStoreEntry[] launchStoreEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            LaunchStoreEntry storeEntry = launchStoreEntryArray[n2];
            LaunchUIEntry uiEntry = LaunchUIEntry.fromStoreEntry(storeEntry);
            if (uiEntry != null) {
                this.entries.add(uiEntry);
            }
            ++n2;
        }
        this.refreshViewer();
    }

    private LaunchStoreEntry[] entriesFromUI() {
        ArrayList<LaunchStoreEntry> result = new ArrayList<LaunchStoreEntry>();
        for (LaunchUIEntry entry : this.entries) {
            LaunchStoreEntry storeEntry = entry.toStoreEntry();
            if (storeEntry == null) continue;
            result.add(storeEntry);
        }
        return result.toArray(new LaunchStoreEntry[result.size()]);
    }

    private static class ColumnManager {
        private final TableColumnLayout columnLayout = new TableColumnLayout();
        private final TableViewer viewer;

        ColumnManager(TableViewer viewer) {
            this.viewer = viewer;
            this.viewer.getTable().getParent().setLayout((Layout)this.columnLayout);
        }

        TableViewerColumn add(String name) {
            TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
            column.getColumn().setText(name);
            this.columnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
            return column;
        }
    }
}

