/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModuleDirective;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.UsesDirective;
import org.eclipse.jdt.core.manipulation.CUCorrectionProposalCore;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.text.correction.AddMissingModuleJavadocTagProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessorCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class AddAllMissingModuleJavadocTagsProposalCore
extends CUCorrectionProposalCore {
    private final ModuleDeclaration fDecl;

    public AddAllMissingModuleJavadocTagsProposalCore(String label, ICompilationUnit cu, ModuleDeclaration decl, int relevance) {
        super(label, cu, null, relevance);
        this.fDecl = decl;
    }

    @Override
    public void addEdits(IDocument document, TextEdit rootEdit) throws CoreException {
        try {
            String name;
            ModuleDirective directive;
            Object comment2;
            Javadoc javadoc = null;
            String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            ICompilationUnit unit = this.getCompilationUnit();
            CompilationUnit cu = (CompilationUnit)this.fDecl.getParent();
            Name moduleName = this.fDecl.getName();
            List comments = cu.getCommentList();
            for (Object comment2 : comments) {
                if (!(comment2 instanceof Javadoc) || comment2.getStartPosition() + comment2.getLength() >= moduleName.getStartPosition()) continue;
                javadoc = (Javadoc)comment2;
            }
            if (javadoc == null) {
                return;
            }
            comment2 = new StringBuilder();
            int insertPosition = AddMissingModuleJavadocTagProposalCore.findInsertPosition(javadoc, document, lineDelimiter);
            List moduleStatements = this.fDecl.moduleStatements();
            int i = moduleStatements.size() - 1;
            while (i >= 0) {
                directive = (ModuleDirective)moduleStatements.get(i);
                if (directive instanceof ProvidesDirective && JavadocTagsSubProcessorCore.findTag(javadoc, "@provides", name = ((ProvidesDirective)directive).getName().getFullyQualifiedName().toString()) == null) {
                    ((StringBuilder)comment2).append(" * ").append("@provides").append(" ").append(name).append(lineDelimiter);
                }
                --i;
            }
            i = moduleStatements.size() - 1;
            while (i >= 0) {
                directive = (ModuleDirective)moduleStatements.get(i);
                if (directive instanceof UsesDirective && JavadocTagsSubProcessorCore.findTag(javadoc, "@uses", name = ((UsesDirective)directive).getName().getFullyQualifiedName().toString()) == null) {
                    ((StringBuilder)comment2).append(" * ").append("@uses").append(" ").append(name).append(lineDelimiter);
                }
                --i;
            }
            IRegion region = document.getLineInformationOfOffset(insertPosition);
            String lineContent = document.get(region.getOffset(), region.getLength());
            String indentString = Strings.getIndentString(lineContent, unit);
            String str = Strings.changeIndent(((StringBuilder)comment2).toString(), 0, unit, indentString, lineDelimiter);
            InsertEdit edit = new InsertEdit(insertPosition, str);
            rootEdit.addChild((TextEdit)edit);
        }
        catch (BadLocationException e) {
            throw new CoreException(JavaUIStatus.createError(4, e));
        }
    }
}

