/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.archive;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.archive.BaseFormat;
import org.eclipse.jgit.archive.TarFormat;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;

public final class TgzFormat
extends BaseFormat
implements ArchiveCommand.Format<ArchiveOutputStream<TarArchiveEntry>> {
    private static final List<String> SUFFIXES = Collections.unmodifiableList(Arrays.asList(".tar.gz", ".tgz"));
    private final ArchiveCommand.Format<ArchiveOutputStream<TarArchiveEntry>> tarFormat = new TarFormat();

    public ArchiveOutputStream createArchiveOutputStream(OutputStream s) throws IOException {
        return this.createArchiveOutputStream(s, Collections.emptyMap());
    }

    public ArchiveOutputStream createArchiveOutputStream(OutputStream s, Map<String, Object> o) throws IOException {
        GzipCompressorOutputStream out;
        int compressionLevel = this.getCompressionLevel(o);
        if (compressionLevel != -1) {
            GzipParameters parameters = new GzipParameters();
            parameters.setCompressionLevel(compressionLevel);
            out = new GzipCompressorOutputStream(s, parameters);
        } else {
            out = new GzipCompressorOutputStream(s);
        }
        return (ArchiveOutputStream)this.tarFormat.createArchiveOutputStream((OutputStream)out, o);
    }

    public void putEntry(ArchiveOutputStream<TarArchiveEntry> out, ObjectId tree, String path, FileMode mode, ObjectLoader loader) throws IOException {
        this.tarFormat.putEntry(out, tree, path, mode, loader);
    }

    public Iterable<String> suffixes() {
        return SUFFIXES;
    }

    public boolean equals(Object other) {
        return other instanceof TgzFormat;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

