/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.criteria.CriterionResource;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.WebappWorkingSetManager;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.WorkingSet;

public class WorkingSetManagerData
extends RequestData {
    private static final int NONE = 0;
    private static final int ADD = 1;
    private static final int REMOVE = 2;
    private static final int EDIT = 3;
    private String name;
    private final WebappWorkingSetManager wsmgr;
    private boolean saved = true;

    public WorkingSetManagerData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.wsmgr = new WebappWorkingSetManager(request, response, this.getLocale());
        this.name = request.getParameter("workingSet");
        try {
            switch (this.getOperation()) {
                case 1: {
                    this.addWorkingSet();
                    break;
                }
                case 2: {
                    this.removeWorkingSet();
                    break;
                }
                case 3: {
                    this.editWorkingSet();
                    break;
                }
            }
        }
        catch (IOException ioe) {
            this.saved = false;
        }
    }

    public void addWorkingSet() throws IOException {
        if (this.name != null && this.name.length() > 0) {
            String[] hrefs = this.request.getParameterValues("hrefs");
            if (hrefs == null) {
                hrefs = new String[]{};
            }
            ArrayList<AdaptableHelpResource> selectedElements = new ArrayList<AdaptableHelpResource>(hrefs.length);
            String[] stringArray = hrefs;
            int n = hrefs.length;
            int n2 = 0;
            while (n2 < n) {
                String href = stringArray[n2];
                AdaptableHelpResource res = this.getAdaptableHelpResource(href);
                if (res != null) {
                    selectedElements.add(res);
                }
                ++n2;
            }
            AdaptableHelpResource[] elements = new AdaptableHelpResource[selectedElements.size()];
            selectedElements.toArray(elements);
            WorkingSet ws = null;
            if (!this.isCriteriaScopeEnabled()) {
                ws = this.wsmgr.createWorkingSet(this.name, elements);
            } else {
                CriterionResource[] criteria = this.getCriteriaResource();
                ws = this.wsmgr.createWorkingSet(this.name, elements, criteria);
            }
            this.wsmgr.addWorkingSet(ws);
        }
    }

    public void removeWorkingSet() {
        WorkingSet ws;
        if (this.name != null && this.name.length() > 0 && (ws = this.wsmgr.getWorkingSet(this.name)) != null) {
            this.wsmgr.removeWorkingSet(ws);
        }
    }

    public void editWorkingSet() throws IOException {
        if (this.name != null && this.name.length() > 0) {
            WorkingSet ws;
            String oldName = this.request.getParameter("oldName");
            if (oldName == null || oldName.length() == 0) {
                oldName = this.name;
            }
            if ((ws = this.wsmgr.getWorkingSet(oldName)) != null) {
                String[] hrefs = this.request.getParameterValues("hrefs");
                if (hrefs == null) {
                    hrefs = new String[]{};
                }
                ArrayList<AdaptableHelpResource> selectedElements = new ArrayList<AdaptableHelpResource>(hrefs.length);
                String[] stringArray = hrefs;
                int n = hrefs.length;
                int n2 = 0;
                while (n2 < n) {
                    String href = stringArray[n2];
                    AdaptableHelpResource res = this.getAdaptableHelpResource(href);
                    if (res != null) {
                        selectedElements.add(res);
                    }
                    ++n2;
                }
                AdaptableHelpResource[] elements = new AdaptableHelpResource[selectedElements.size()];
                selectedElements.toArray(elements);
                ws.setElements(elements);
                ws.setName(this.name);
                if (this.isCriteriaScopeEnabled()) {
                    ws.setCriteria(this.getCriteriaResource());
                }
                this.wsmgr.workingSetChanged(ws);
            }
        }
    }

    public String[] getWorkingSets() {
        WorkingSet[] workingSets = this.wsmgr.getWorkingSets();
        String[] sets = new String[workingSets.length];
        int i = 0;
        while (i < workingSets.length) {
            sets[i] = workingSets[i].getName();
            ++i;
        }
        return sets;
    }

    public String getWorkingSetName() {
        if (this.name == null || this.name.length() == 0) {
            this.name = this.wsmgr.getCurrentWorkingSet();
            if (this.name == null || this.name.length() == 0 || this.wsmgr.getWorkingSet(this.name) == null) {
                this.name = ServletResources.getString("All", this.request);
            }
        }
        return this.name;
    }

    public WorkingSet getWorkingSet() {
        if (this.name != null && this.name.length() > 0) {
            return this.wsmgr.getWorkingSet(this.name);
        }
        return null;
    }

    public boolean isCurrentWorkingSet(int i) {
        WorkingSet[] workingSets = this.wsmgr.getWorkingSets();
        return workingSets[i].getName().equals(this.name);
    }

    private int getOperation() {
        String op = this.request.getParameter("operation");
        if ("add".equals(op)) {
            return 1;
        }
        if ("remove".equals(op)) {
            return 2;
        }
        if ("edit".equals(op)) {
            return 3;
        }
        return 0;
    }

    private AdaptableHelpResource getAdaptableHelpResource(String internalId) {
        AdaptableToc res = this.wsmgr.getAdaptableToc(internalId);
        if (res == null) {
            res = this.wsmgr.getAdaptableTopic(internalId);
        }
        return res;
    }

    public String getSaveError() {
        if (this.saved) {
            return null;
        }
        return UrlUtil.JavaScriptEncode(ServletResources.getString("cookieSaveFailed", this.request));
    }

    private CriterionResource[] getCriteriaResource() {
        List<String> category = Arrays.asList(this.getCriterionIds());
        String[] criteria = this.request.getParameterValues("criteria");
        if (criteria == null) {
            criteria = new String[]{};
        }
        HashMap<String, HashSet<String>> selectedElements = new HashMap<String, HashSet<String>>();
        String[] stringArray = criteria;
        int n = criteria.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                String criterion = stringArray[n2];
                if (category.contains(criterion)) {
                    List<String> allValuesInCategory = Arrays.asList(this.getCriterionValueIds(criterion));
                    if (!allValuesInCategory.isEmpty()) {
                        HashSet<String> elements = (HashSet<String>)selectedElements.get(criterion);
                        if (elements == null) {
                            elements = new HashSet<String>();
                        }
                        elements.addAll(allValuesInCategory);
                        selectedElements.put(criterion, elements);
                    }
                } else {
                    int len = criterion.length();
                    if (criterion.charAt(len - 1) == '_') {
                        String indexStr = criterion.substring(criterion.lastIndexOf(95, len - 2) + 1, len - 1);
                        int index = 0;
                        try {
                            index = Integer.parseInt(indexStr);
                        }
                        catch (Exception e) {
                            break block13;
                        }
                        String criterionName = criterion.substring(0, criterion.lastIndexOf(95, len - 2));
                        if (category.contains(criterionName)) {
                            String selectedValue;
                            String[] values = this.getCriterionValueIds(criterionName);
                            if (index >= 0 && index < values.length && (selectedValue = values[index]) != null && selectedValue.length() != 0) {
                                HashSet<String> existedElements = (HashSet<String>)selectedElements.get(criterionName);
                                if (existedElements == null) {
                                    existedElements = new HashSet<String>();
                                }
                                existedElements.add(selectedValue);
                                selectedElements.put(criterionName, existedElements);
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        ArrayList<CriterionResource> resources = new ArrayList<CriterionResource>();
        for (Map.Entry entry : selectedElements.entrySet()) {
            String key = (String)entry.getKey();
            Set values = (Set)entry.getValue();
            CriterionResource resource = new CriterionResource(key, new ArrayList(values));
            resources.add(resource);
        }
        CriterionResource[] processedResources = new CriterionResource[resources.size()];
        resources.toArray(processedResources);
        return processedResources;
    }

    public boolean isCriteriaScopeEnabled() {
        return this.wsmgr.isCriteriaScopeEnabled();
    }

    private String[] getCriterionIds() {
        return this.wsmgr.getCriterionIds();
    }

    private String[] getCriterionValueIds(String criterionId) {
        return this.wsmgr.getCriterionValueIds(criterionId);
    }
}

