/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import java.util.HashMap;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleTextChangeListener;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.refactoring.BundleManifestChange;
import org.eclipse.pde.internal.ui.refactoring.FindReferenceOperation;
import org.eclipse.pde.internal.ui.refactoring.MovedTextFileChange;
import org.eclipse.pde.internal.ui.refactoring.PDERenameParticipant;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class ContainerRenameParticipant
extends PDERenameParticipant {
    public String getName() {
        return PDEUIMessages.ContainerRenameParticipant_renameFolders;
    }

    protected boolean initialize(Object element) {
        IProject project;
        if (element instanceof IContainer && WorkspaceModelManager.isPluginProject((IProject)(project = ((IContainer)element).getProject()))) {
            IPath path = ((IContainer)element).getProjectRelativePath().removeLastSegments(1);
            String newName = path.append(this.getArguments().getNewName()).toString();
            this.fProject = project;
            this.fElements = new HashMap();
            this.fElements.put(element, newName);
            return true;
        }
        return false;
    }

    @Override
    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fElements.size() == 1 && this.fElements.keySet().iterator().next() instanceof IProject) {
            if (!this.getArguments().getUpdateReferences()) {
                return null;
            }
            return this.createManifestChange(pm);
        }
        return super.createChange(pm);
    }

    protected Change createManifestChange(IProgressMonitor monitor) throws CoreException {
        IFile manifest = PDEProject.getManifest((IProject)this.fProject);
        if (manifest.exists()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
            try {
                String newText = (String)this.fElements.get(this.fProject);
                CompositeChange result = new CompositeChange(PDEUIMessages.ContainerRenameParticipant_renameBundleId);
                Bundle bundle = BundleManifestChange.getBundle(manifest, (IProgressMonitor)subMonitor.split(1));
                if (bundle != null) {
                    BundleTextChangeListener listener = new BundleTextChangeListener(((BundleModel)bundle.getModel()).getDocument());
                    bundle.getModel().addModelChangedListener((IModelChangedListener)listener);
                    BundleSymbolicNameHeader header = (BundleSymbolicNameHeader)bundle.getManifestHeader("Bundle-SymbolicName");
                    if (header != null) {
                        String calcProjectId = IdUtil.getValidId((String)this.fProject.getName());
                        String oldText = header.getId();
                        if (!oldText.equals(calcProjectId)) {
                            return null;
                        }
                        String newId = IdUtil.getValidId((String)newText);
                        header.setId(newId);
                        IProject newProject = ((IWorkspaceRoot)manifest.getProject().getParent()).getProject(newText);
                        IPath oldManifest = manifest.getFullPath().removeFirstSegments(1);
                        IFile newManifest = newProject.getFile(oldManifest);
                        MovedTextFileChange change = new MovedTextFileChange("", newManifest, manifest);
                        MultiTextEdit edit = new MultiTextEdit();
                        edit.addChildren(listener.getTextOperations());
                        change.setEdit((TextEdit)edit);
                        PDEModelUtility.setChangeTextType(change, manifest);
                        result.add((Change)change);
                        FindReferenceOperation op = new FindReferenceOperation(PluginRegistry.findModel((IProject)this.fProject).getBundleDescription(), newId);
                        op.run((IProgressMonitor)subMonitor.split(2));
                        result.addAll(op.getChanges());
                        CompositeChange compositeChange = result;
                        return compositeChange;
                    }
                }
            }
            catch (CoreException | MalformedTreeException throwable) {
            }
            finally {
                FileBuffers.getTextFileBufferManager().disconnect(manifest.getFullPath(), LocationKind.NORMALIZE, (IProgressMonitor)subMonitor.split(1));
            }
        }
        return null;
    }
}

