/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SearchablePluginsManager;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public class AddToJavaSearchJob
extends WorkspaceJob {
    private static final String JOB_FAMILY_ID = "AddToJavaSearchJob";
    private IPluginModelBase[] fBundles;
    private boolean fAdd;
    private final ITargetDefinition fTargetDefinition;

    public static void synchWithTarget(ITargetDefinition target) {
        Job.getJobManager().cancel((Object)JOB_FAMILY_ID);
        AddToJavaSearchJob job = new AddToJavaSearchJob(target);
        job.schedule();
    }

    public static void clearAll() {
        Job.getJobManager().cancel((Object)JOB_FAMILY_ID);
        AddToJavaSearchJob job = new AddToJavaSearchJob(null, false);
        job.schedule();
    }

    public static void changeBundles(IPluginModelBase[] bundles, boolean add) {
        Job.getJobManager().cancel((Object)JOB_FAMILY_ID);
        AddToJavaSearchJob job = new AddToJavaSearchJob(bundles, add);
        job.schedule();
    }

    private AddToJavaSearchJob(ITargetDefinition target) {
        super(PDEUIMessages.AddToJavaSearchJob_0);
        this.fTargetDefinition = target;
        this.fAdd = true;
        this.fBundles = null;
    }

    private AddToJavaSearchJob(IPluginModelBase[] bundles, boolean add) {
        super(PDEUIMessages.AddToJavaSearchJob_0);
        this.fTargetDefinition = null;
        this.fBundles = bundles;
        this.fAdd = add;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        int ticks = this.fTargetDefinition != null ? 100 : 25;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)ticks);
        if (subMon.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        SearchablePluginsManager manager = PDECore.getDefault().getSearchablePluginsManager();
        if (this.fTargetDefinition != null) {
            manager.removeAllFromJavaSearch();
            if (!this.fTargetDefinition.isResolved()) {
                IStatus status = this.fTargetDefinition.resolve((IProgressMonitor)subMon.split(50));
                if (!status.isOK()) {
                    return status;
                }
                subMon.subTask("");
            } else {
                subMon.worked(50);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            TargetBundle[] bundles = this.fTargetDefinition.getBundles();
            this.fAdd = true;
            ArrayList<IPluginModelBase> models = new ArrayList<IPluginModelBase>(bundles.length);
            TargetBundle[] targetBundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                TargetBundle bundle = targetBundleArray[n2];
                IPluginModelBase model = PluginRegistry.findModel((String)bundle.getBundleInfo().getSymbolicName());
                if (model != null) {
                    models.add(model);
                }
                ++n2;
            }
            subMon.worked(25);
            this.fBundles = models.toArray(new IPluginModelBase[models.size()]);
        }
        if (subMon.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.fAdd) {
            manager.addToJavaSearch(this.fBundles);
        } else if (this.fBundles != null) {
            manager.removeFromJavaSearch(this.fBundles);
        } else {
            manager.removeAllFromJavaSearch();
        }
        subMon.worked(25);
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return JOB_FAMILY_ID.equals(family);
    }
}

