/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.preferences;

import aQute.bnd.build.Workspace;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.bndtools.api.NamedPlugin;
import org.bndtools.headless.build.manager.api.HeadlessBuildManager;
import org.bndtools.versioncontrol.ignores.manager.api.VersionControlIgnoresManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.pde.bnd.ui.TeamUtils;
import org.eclipse.pde.bnd.ui.preferences.QuickFixVersioning;

public class BndPreferences {
    private static final boolean DEFAULT_PREF_USE_ALIAS_REQUIREMENTS = true;
    private static final boolean DEFAULT_PREF_PARALLEL = false;
    private static final boolean DEFAULT_PREF_WORKSPACE_OFFLINE = false;
    private static final String DEFAULT_PREF_TEMPLATE_REPO_URI_LIST = "https://raw.githubusercontent.com/bndtools/bundle-hub/master/index.xml.gz";
    private static final boolean DEFAULT_PREF_ENABLE_TEMPLATE_REPO = false;
    private static final boolean DEFAULT_PREF_VCS_IGNORES_CREATE = true;
    private static final String DEFAULT_PREF_HEADLESS_BUILD_PLUGINS = "";
    private static final boolean DEFAULT_PREF_HEADLESS_BUILD_CREATE = true;
    private static final boolean DEFAULT_PREF_BUILDBEFORELAUNCH = true;
    private static final boolean DEFAULT_PREF_WARN_EXISTING_LAUNCH = true;
    private static final String DEFAULT_PREF_VCS_IGNORES_PLUGINS = "";
    private static final String DEFAULT_PREF_EXPLORER_PROMPT = "";
    private static final String PREF_ENABLE_SUB_BUNDLES = "enableSubBundles";
    private static final String PREF_NOASK_PACKAGEINFO = "noAskPackageInfo";
    private static final String PREF_USE_ALIAS_REQUIREMENTS = "useAliasRequirements";
    private static final String PREF_HIDE_INITIALISE_CNF_WIZARD = "hideInitialiseCnfWizard";
    private static final String PREF_HIDE_INITIALISE_CNF_ADVICE = "hideInitialiseCnfAdvice";
    private static final String PREF_WARN_EXISTING_LAUNCH = "warnExistingLaunch";
    private static final String PREF_HIDE_WARNING_EXTERNAL_FILE = "hideExternalFileWarning";
    private static final String PREF_BUILD_LOGGING = "buildLogging";
    private static final String PREF_EDITOR_OPEN_SOURCE_TAB = "editorOpenSourceTab";
    private static final String PREF_HEADLESS_BUILD_CREATE = "headlessBuildCreate";
    private static final String PREF_HEADLESS_BUILD_PLUGINS = "headlessBuildPlugins";
    private static final String PREF_VCS_IGNORES_CREATE = "versionControlIgnoresCreate";
    private static final String PREF_VCS_IGNORES_PLUGINS = "versionControlIgnoresPlugins";
    private static final String PREF_BUILDBEFORELAUNCH = "buildBeforeLaunch";
    private static final String PREF_ENABLE_TEMPLATE_REPO = "enableTemplateRepo";
    private static final String PREF_TEMPLATE_REPO_URI_LIST = "templateRepoUriList";
    private static final String PREF_EXPLORER_PROMPT = "prompt";
    private static final String PREF_PARALLEL = "parallel";
    static final String PREF_WORKSPACE_OFFLINE = "workspaceIsOffline";
    private static final boolean DEFAULT_PREF_NOASK_PACKAGEINFO = false;
    private static final boolean DEFAULT_PREF_HIDE_INITIALISE_CNF_WIZARD = false;
    private static final String DEFAULT_PREF_ENABLE_SUB_BUNDLES = null;
    private static final int DEFAULT_PREF_BUILD_LOGGING = 0;
    private static final boolean DEFAULT_PREF_HIDE_INITIALISE_CNF_ADVICE = false;
    private static final boolean DEFAULT_PREF_HIDE_WARNING_EXTERNAL_FILE = false;
    private static final boolean DEFAULT_PREF_EDITOR_OPEN_SOURCE_TAB = false;
    private final IPreferenceStore store;
    private final IProject project;

    public BndPreferences(IProject project, IPreferenceStore store) {
        this.store = store;
        this.project = project;
        if (store != null) {
            store.setDefault(PREF_WARN_EXISTING_LAUNCH, true);
            store.setDefault(PREF_BUILDBEFORELAUNCH, true);
            store.setDefault(PREF_HEADLESS_BUILD_CREATE, true);
            store.setDefault(PREF_HEADLESS_BUILD_PLUGINS, "");
            store.setDefault(PREF_VCS_IGNORES_CREATE, true);
            store.setDefault(PREF_VCS_IGNORES_PLUGINS, "");
            store.setDefault(PREF_ENABLE_TEMPLATE_REPO, false);
            store.setDefault(PREF_TEMPLATE_REPO_URI_LIST, DEFAULT_PREF_TEMPLATE_REPO_URI_LIST);
            store.setDefault(PREF_WORKSPACE_OFFLINE, false);
            store.setDefault(PREF_PARALLEL, false);
            store.setDefault(PREF_USE_ALIAS_REQUIREMENTS, true);
            store.setDefault("quickfixVersioning", QuickFixVersioning.DEFAULT.toString());
            store.setDefault(PREF_EXPLORER_PROMPT, "");
        }
    }

    private String mapToPreference(Map<String, Boolean> names) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Boolean> nameEntry : names.entrySet()) {
            if (!nameEntry.getValue().booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(nameEntry.getKey());
        }
        return sb.toString();
    }

    private Map<String, Boolean> preferenceToMap(String preference, Collection<? extends NamedPlugin> allPluginsInformation, boolean onlyEnabled) {
        List<String> names = null;
        if (preference != null && !preference.isEmpty()) {
            names = Arrays.asList(preference.split("\\|"));
        }
        boolean atLeastOneEnabled = false;
        TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
        for (NamedPlugin namedPlugin : allPluginsInformation) {
            boolean enabled = names == null ? namedPlugin.isEnabledByDefault() && !namedPlugin.isDeprecated() : names.contains(namedPlugin.getName());
            map.put(namedPlugin.getName(), enabled);
            boolean bl = atLeastOneEnabled = atLeastOneEnabled || enabled;
        }
        if (!atLeastOneEnabled && map.size() > 0) {
            for (String string : map.keySet()) {
                map.put(string, Boolean.TRUE);
            }
        }
        if (onlyEnabled) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry entry : map.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                hashSet.add((String)entry.getKey());
            }
            for (String plugin : hashSet) {
                map.remove(plugin);
            }
        }
        return map;
    }

    public void setNoAskPackageInfo(boolean noAskPackageInfo) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_NOASK_PACKAGEINFO, noAskPackageInfo);
    }

    public void setUseAliasRequirements(boolean useAliases) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_USE_ALIAS_REQUIREMENTS, useAliases);
    }

    public boolean getNoAskPackageInfo() {
        if (this.store == null) {
            return false;
        }
        return this.store.getBoolean(PREF_NOASK_PACKAGEINFO);
    }

    public boolean getUseAliasRequirements() {
        if (this.store == null) {
            return true;
        }
        return this.store.getBoolean(PREF_USE_ALIAS_REQUIREMENTS);
    }

    public void setHideInitCnfWizard(boolean hide) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_HIDE_INITIALISE_CNF_WIZARD, hide);
    }

    public boolean getHideInitCnfWizard() {
        if (this.store == null) {
            return false;
        }
        return this.store.getBoolean(PREF_HIDE_INITIALISE_CNF_WIZARD);
    }

    public void setWarnExistingLaunch(boolean warnExistingLaunch) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_WARN_EXISTING_LAUNCH, warnExistingLaunch);
    }

    public boolean getWarnExistingLaunches() {
        if (this.store == null) {
            return true;
        }
        return this.store.getBoolean(PREF_WARN_EXISTING_LAUNCH);
    }

    public void setEnableSubBundles(String enableSubs) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_ENABLE_SUB_BUNDLES, enableSubs);
    }

    public String getEnableSubBundles() {
        if (this.store == null) {
            return DEFAULT_PREF_ENABLE_SUB_BUNDLES;
        }
        return this.store.getString(PREF_ENABLE_SUB_BUNDLES);
    }

    public void setBuildLogging(int buildLogging) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_BUILD_LOGGING, buildLogging);
    }

    public int getBuildLogging() {
        if (this.store == null) {
            return 0;
        }
        return this.store.getInt(PREF_BUILD_LOGGING);
    }

    public void setHideInitCnfAdvice(boolean hide) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_HIDE_INITIALISE_CNF_ADVICE, hide);
    }

    public boolean getHideInitCnfAdvice() {
        if (this.store == null) {
            return false;
        }
        return this.store.getBoolean(PREF_HIDE_INITIALISE_CNF_ADVICE);
    }

    public void setHideWarningExternalFile(boolean hide) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_HIDE_WARNING_EXTERNAL_FILE, hide);
    }

    public boolean getHideWarningExternalFile() {
        if (this.store == null) {
            return false;
        }
        return this.store.getBoolean(PREF_HIDE_WARNING_EXTERNAL_FILE);
    }

    public boolean getEnableTemplateRepo() {
        if (this.store == null) {
            return false;
        }
        return this.store.getBoolean(PREF_ENABLE_TEMPLATE_REPO);
    }

    public void setEnableTemplateRepo(boolean enable) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_ENABLE_TEMPLATE_REPO, enable);
    }

    public List<String> getTemplateRepoUriList() {
        if (this.store == null) {
            return List.of(DEFAULT_PREF_TEMPLATE_REPO_URI_LIST);
        }
        String urisStr = this.store.getString(PREF_TEMPLATE_REPO_URI_LIST);
        return Arrays.asList(urisStr.split("\\s"));
    }

    public void setTemplateRepoUriList(List<String> uris) {
        if (this.store == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> i = uris.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(' ');
        }
        this.store.setValue(PREF_TEMPLATE_REPO_URI_LIST, sb.toString());
    }

    public IPreferenceStore getStore() {
        return this.store;
    }

    public void setEditorOpenSourceTab(boolean editorOpenSourceTab) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_EDITOR_OPEN_SOURCE_TAB, editorOpenSourceTab);
    }

    public boolean getEditorOpenSourceTab() {
        if (this.store == null) {
            return false;
        }
        return this.store.getBoolean(PREF_EDITOR_OPEN_SOURCE_TAB);
    }

    public void setHeadlessBuildCreate(boolean headlessCreate) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_HEADLESS_BUILD_CREATE, headlessCreate);
    }

    public boolean getHeadlessBuildCreate() {
        if (this.store == null) {
            return true;
        }
        return this.store.getBoolean(PREF_HEADLESS_BUILD_CREATE);
    }

    public void setHeadlessBuildPlugins(Map<String, Boolean> names) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_HEADLESS_BUILD_PLUGINS, this.mapToPreference(names));
    }

    public Map<String, Boolean> getHeadlessBuildPlugins(Collection<? extends NamedPlugin> allPluginsInformation, boolean onlyEnabled) {
        if (!this.getHeadlessBuildCreate() || this.store == null) {
            return Collections.emptyMap();
        }
        return this.preferenceToMap(this.store.getString(PREF_HEADLESS_BUILD_PLUGINS), allPluginsInformation, onlyEnabled);
    }

    public Set<String> getHeadlessBuildPluginsEnabled(HeadlessBuildManager manager, Set<String> plugins) {
        if (plugins != null && !plugins.isEmpty()) {
            return plugins;
        }
        return this.getHeadlessBuildPlugins(manager.getAllPluginsInformation(), true).keySet();
    }

    public void setVersionControlIgnoresCreate(boolean versionControlIgnoresCreate) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_VCS_IGNORES_CREATE, versionControlIgnoresCreate);
    }

    public boolean getVersionControlIgnoresCreate() {
        if (this.store == null) {
            return true;
        }
        return this.store.getBoolean(PREF_VCS_IGNORES_CREATE);
    }

    public void setVersionControlIgnoresPlugins(Map<String, Boolean> names) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_VCS_IGNORES_PLUGINS, this.mapToPreference(names));
    }

    public Map<String, Boolean> getVersionControlIgnoresPlugins(Collection<? extends NamedPlugin> allPluginsInformation, boolean onlyEnabled) {
        if (!this.getVersionControlIgnoresCreate() || this.store == null) {
            return Collections.emptyMap();
        }
        return this.preferenceToMap(this.store.getString(PREF_VCS_IGNORES_PLUGINS), allPluginsInformation, onlyEnabled);
    }

    public void setPrompt(String prompt) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_EXPLORER_PROMPT, prompt);
    }

    public String getPrompt() {
        if (this.store == null) {
            return "";
        }
        return this.store.getString(PREF_EXPLORER_PROMPT);
    }

    public Closeable onPrompt(Consumer<String> listener) {
        return this.onString(PREF_EXPLORER_PROMPT, listener);
    }

    public void setParallel(boolean parallel) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_PARALLEL, parallel);
    }

    public boolean isParallel() {
        if (this.store == null) {
            return false;
        }
        return this.store.getBoolean(PREF_PARALLEL);
    }

    public Closeable onString(String key, Consumer<String> listener) {
        if (this.store == null) {
            return () -> {};
        }
        IPropertyChangeListener l = e -> {
            if (e.getProperty().equals(key)) {
                listener.accept((String)e.getNewValue());
            }
        };
        this.addPropertyChangeListener(l);
        listener.accept(this.store.getString(key));
        return () -> this.removePropertyChangeListener(l);
    }

    public Set<String> getVersionControlIgnoresPluginsEnabled(VersionControlIgnoresManager manager, IJavaProject project, Set<String> plugins) {
        Set managingPlugins;
        VersionControlIgnoresManager versionControlIgnoresManager;
        String repositoryProviderId;
        if (plugins != null && !plugins.isEmpty()) {
            return plugins;
        }
        if (project != null && (repositoryProviderId = TeamUtils.getProjectRepositoryProviderId(project)) != null && (versionControlIgnoresManager = (VersionControlIgnoresManager)Adapters.adapt((Object)project.getProject(), VersionControlIgnoresManager.class)) != null && (managingPlugins = versionControlIgnoresManager.getPluginsForProjectRepositoryProviderId(repositoryProviderId)) != null && !managingPlugins.isEmpty()) {
            return managingPlugins;
        }
        return this.getVersionControlIgnoresPlugins(manager.getAllPluginsInformation(), true).keySet();
    }

    public boolean getBuildBeforeLaunch() {
        if (this.store == null) {
            return true;
        }
        return this.store.getBoolean(PREF_BUILDBEFORELAUNCH);
    }

    public void setBuildBeforeLaunch(boolean b) {
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_BUILDBEFORELAUNCH, b);
    }

    public QuickFixVersioning getQuickFixVersioning() {
        if (this.store == null) {
            return QuickFixVersioning.DEFAULT;
        }
        return QuickFixVersioning.parse(this.store.getString("quickfixVersioning"));
    }

    public void setQuickFixVersioning(QuickFixVersioning qfv) {
        if (this.store == null) {
            return;
        }
        if (qfv == null) {
            qfv = QuickFixVersioning.DEFAULT;
        }
        this.store.setValue("quickfixVersioning", qfv.toString());
    }

    public boolean isWorkspaceOffline() {
        if (this.store == null) {
            return false;
        }
        return this.store.getBoolean(PREF_WORKSPACE_OFFLINE);
    }

    public void setWorkspaceOffline(boolean b) {
        Workspace workspace = (Workspace)Adapters.adapt((Object)this.project, Workspace.class);
        if (workspace != null) {
            workspace.setOffline(b);
        }
        if (this.store == null) {
            return;
        }
        this.store.setValue(PREF_WORKSPACE_OFFLINE, b);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.store.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.store.removePropertyChangeListener(listener);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.store);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BndPreferences other = (BndPreferences)obj;
        return Objects.equals(this.project, other.project) && Objects.equals(this.store, other.store);
    }
}

