/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner;

import java.io.File;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.rcptt.reporting.util.Q7ReportIterator;
import org.eclipse.rcptt.runner.RunnerConfiguration;
import org.eclipse.rcptt.runner.RunnerOptionsHandler;
import org.eclipse.rcptt.runner.util.Reporter;
import org.eclipse.rcptt.runner.util.ResultsHandler;
import org.eclipse.rcptt.runner.util.TargetPlatformChecker;
import org.eclipse.rcptt.runner.util.TargetPlatformFail;
import org.eclipse.rcptt.runner.util.TestsRunner;

public class HeadlessRunner {
    public final Reporter reporter = new Reporter();
    private final RunnerConfiguration conf;
    public final TargetPlatformChecker tpc;

    public HeadlessRunner(RunnerConfiguration conf) {
        this.conf = conf;
        this.tpc = new TargetPlatformChecker(conf);
    }

    public int performCoolThings() throws Exception {
        this.clearConfigurations();
        this.clearPDEFiles();
        RunnerOptionsHandler runnerOptions = new RunnerOptionsHandler();
        runnerOptions.applyOptions(this.conf.testOptions);
        try {
            this.tpc.initAndCheckTargetPlatform();
        }
        catch (CoreException e) {
            e.printStackTrace(System.err);
            throw new TargetPlatformFail();
        }
        TestsRunner testsRunner = new TestsRunner(this.conf, this, new ResultsHandler(this.conf, runnerOptions.isRestartAUTOnFailures()));
        Q7ReportIterator reportIterator = testsRunner.findAndRunTests();
        this.reporter.report(reportIterator, this, this.conf);
        return testsRunner.getFailedCount();
    }

    private void clearPDEFiles() {
        File[] listFiles;
        File file = PDECore.getDefault().getStateLocation().toFile();
        File[] fileArray = listFiles = file.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.getName().startsWith(".") || f.getName().equalsIgnoreCase(".local_targets") || f.getName().equalsIgnoreCase(".install_folders")) {
                HeadlessRunner.deleteDir(f);
            }
            ++n2;
        }
    }

    private void clearConfigurations() {
        DebugPlugin debug = DebugPlugin.getDefault();
        ILaunchManager launchManager = debug.getLaunchManager();
        try {
            Method method = LaunchManager.class.getDeclaredMethod("clearAllLaunchConfigurations", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)launchManager, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        File launchesPath = debug.getStateLocation().append(".launches").toFile();
        HeadlessRunner.deleteDir(launchesPath);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = HeadlessRunner.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }
}

