/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.text.edits.TextEditGroup;

public class JavadocTagsSubProcessorCore {
    private static String[] TAG_ORDER = new String[]{"@author", "@version", "@param", "@return", "@throws", "@see", "@since", "@serial", "@deprecated"};

    public static Set<String> getPreviousTypeParamNames(List<TypeParameter> typeParams, ASTNode missingNode) {
        HashSet<String> previousNames = new HashSet<String>();
        for (TypeParameter curr : typeParams) {
            if (curr == missingNode) {
                return previousNames;
            }
            previousNames.add(String.valueOf('<') + curr.getName().getIdentifier() + '>');
        }
        return previousNames;
    }

    public static TagElement findTag(Javadoc javadoc, String name, String arg) {
        List tags = javadoc.tags();
        for (TagElement curr : tags) {
            if (!name.equals(curr.getTagName())) continue;
            if (arg != null) {
                String argument = JavadocTagsSubProcessorCore.getArgument(curr);
                if (!arg.equals(argument)) continue;
                return curr;
            }
            return curr;
        }
        return null;
    }

    public static TagElement findParamTag(Javadoc javadoc, String arg) {
        List tags = javadoc.tags();
        for (TagElement curr : tags) {
            String argument;
            String currName = curr.getTagName();
            if (!"@param".equals(currName) || !arg.equals(argument = JavadocTagsSubProcessorCore.getArgument(curr))) continue;
            return curr;
        }
        return null;
    }

    public static TagElement findThrowsTag(Javadoc javadoc, String arg) {
        List tags = javadoc.tags();
        for (TagElement curr : tags) {
            String argument;
            String currName = curr.getTagName();
            if (!"@throws".equals(currName) && !"@exception".equals(currName) || !arg.equals(argument = JavadocTagsSubProcessorCore.getArgument(curr))) continue;
            return curr;
        }
        return null;
    }

    public static void insertTag(ListRewrite rewriter, TagElement newElement, Set<String> sameKindLeadingNames) {
        JavadocTagsSubProcessorCore.insertTag(rewriter, newElement, sameKindLeadingNames, null);
    }

    public static void insertTag(ListRewrite rewriter, TagElement newElement, Set<String> sameKindLeadingNames, TextEditGroup groupDescription) {
        List tags = rewriter.getRewrittenList();
        String insertedTagName = newElement.getTagName();
        TagElement after = null;
        int tagRanking = JavadocTagsSubProcessorCore.getTagRanking(insertedTagName);
        int i = tags.size() - 1;
        while (i >= 0) {
            String arg;
            TagElement curr = (TagElement)tags.get(i);
            String tagName = curr.getTagName();
            if (tagName == null || tagRanking > JavadocTagsSubProcessorCore.getTagRanking(tagName)) {
                after = curr;
                break;
            }
            if (sameKindLeadingNames != null && JavadocTagsSubProcessorCore.isSameTag(insertedTagName, tagName) && (arg = JavadocTagsSubProcessorCore.getArgument(curr)) != null && sameKindLeadingNames.contains(arg)) {
                after = curr;
                break;
            }
            --i;
        }
        if (after != null) {
            rewriter.insertAfter((ASTNode)newElement, after, groupDescription);
        } else {
            rewriter.insertFirst((ASTNode)newElement, groupDescription);
        }
    }

    private static boolean isSameTag(String insertedTagName, String tagName) {
        if (insertedTagName.equals(tagName)) {
            return true;
        }
        if ("@exception".equals(tagName)) {
            return "@throws".equals(insertedTagName);
        }
        return false;
    }

    private static int getTagRanking(String tagName) {
        if ("@exception".equals(tagName)) {
            tagName = "@throws";
        }
        int i = 0;
        while (i < TAG_ORDER.length) {
            if (tagName.equals(TAG_ORDER[i])) {
                return i;
            }
            ++i;
        }
        return TAG_ORDER.length;
    }

    private static String getArgument(TagElement curr) {
        List fragments = curr.fragments();
        if (!fragments.isEmpty()) {
            Object first = fragments.get(0);
            if (first instanceof Name) {
                return ASTNodes.getSimpleNameIdentifier((Name)first);
            }
            if (first instanceof TextElement && "@param".equals(curr.getTagName())) {
                String text = ((TextElement)first).getText();
                if ("<".equals(text) && fragments.size() >= 3) {
                    Object second = fragments.get(1);
                    Object third = fragments.get(2);
                    if (second instanceof Name && third instanceof TextElement && ">".equals(((TextElement)third).getText())) {
                        return String.valueOf('<') + ASTNodes.getSimpleNameIdentifier((Name)second) + '>';
                    }
                } else if (text.startsWith(String.valueOf('<')) && text.endsWith(String.valueOf('>')) && text.length() > 2) {
                    return text.substring(1, text.length() - 1);
                }
            }
        }
        return null;
    }

    private JavadocTagsSubProcessorCore() {
    }
}

