/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.api.tools.internal.builder.AbstractTypeLeakDetector;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;

public class LeakImplementsProblemDetector
extends AbstractTypeLeakDetector {
    public LeakImplementsProblemDetector(Set<String> nonApiPackageNames) {
        super(nonApiPackageNames);
    }

    @Override
    public int getReferenceKinds() {
        return 2;
    }

    @Override
    protected String getSeverityKey() {
        return "LEAK_IMPLEMENT";
    }

    @Override
    protected int getProblemFlags(IReference reference) {
        return 2;
    }

    @Override
    public boolean isProblem(IReference reference, IProgressMonitor monitor) {
        boolean isProb = super.isProblem(reference, monitor);
        if (!isProb) {
            IApiMember member = reference.getResolvedReference();
            IApiMember sourceMember = reference.getMember();
            try {
                IApiAnnotations annotationsSource;
                IApiAnnotations annotations = member.getApiComponent().getApiDescription().resolveAnnotations(member.getHandle());
                if (annotations != null && RestrictionModifiers.isImplementRestriction(annotations.getRestrictions()) && (annotationsSource = member.getApiComponent().getApiDescription().resolveAnnotations(sourceMember.getHandle())) != null && !RestrictionModifiers.isImplementRestriction(annotationsSource.getRestrictions())) {
                    isProb = true;
                }
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
                LeakImplementsProblemDetector.checkIfDisposed(member.getApiComponent(), monitor);
            }
        }
        return isProb;
    }
}

