/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.aut;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.rcptt.core.launching.events.AutBundleState;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutLaunchListener;
import org.eclipse.rcptt.launching.AutLaunchState;

public class OutputCaptureLaunchListener
implements AutLaunchListener {
    private PrintStreamListener listener;
    private File logFile;

    public OutputCaptureLaunchListener(File logFile) {
        this.logFile = logFile;
    }

    @Override
    public void stateChanged(AutLaunch launch, AutLaunchState state) {
        this.startLogging(launch.getLaunch().getProcesses());
        if (state.equals((Object)AutLaunchState.TERMINATE)) {
            this.stopLogging();
        }
    }

    private void startLogging(IProcess[] processes) {
        try {
            if (this.listener == null) {
                this.listener = new PrintStreamListener(new PrintStream((OutputStream)new FileOutputStream(this.logFile, true), true, Charsets.UTF_8.name()));
            }
            IProcess[] iProcessArray = processes;
            int n = processes.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess process = iProcessArray[n2];
                IStreamsProxy proxy = process.getStreamsProxy();
                if (proxy != null) {
                    IStreamMonitor[] iStreamMonitorArray = new IStreamMonitor[]{proxy.getOutputStreamMonitor(), proxy.getErrorStreamMonitor()};
                    int n3 = iStreamMonitorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IStreamMonitor sm = iStreamMonitorArray[n4];
                        this.listener.streamAppended(sm.getContents(), sm);
                        sm.removeListener((IStreamListener)this.listener);
                        sm.addListener((IStreamListener)this.listener);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (IOException e) {
            Q7LaunchingPlugin.log(String.format("Error appending to log file '%s'", this.logFile.getAbsolutePath()), e);
            return;
        }
    }

    private void stopLogging() {
        if (this.listener != null) {
            this.listener.stream.flush();
            this.listener.stream.close();
            this.listener = null;
        }
    }

    @Override
    public void autStarted(AutLaunch baseAutLaunch, int eclPort, int teslaPort) {
    }

    @Override
    public void autInit(AutLaunch baseAutLaunch, List<AutBundleState> bundleState) {
    }

    @Override
    public void autLocationChange(BaseAutLaunch baseAutLaunch, String location) {
    }

    private static class PrintStreamListener
    implements IStreamListener {
        public final PrintStream stream;

        public PrintStreamListener(PrintStream stream) {
            this.stream = stream;
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            if (this.stream == null) {
                return;
            }
            this.stream.append(text);
            if (monitor instanceof IFlushableStreamMonitor) {
                ((IFlushableStreamMonitor)monitor).flushContents();
            }
        }
    }
}

