/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.resources;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.DefaultVerificationMaker;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.resources.ImportUtils;
import org.eclipse.rcptt.resources.WSUtils;
import org.eclipse.rcptt.resources.WorkspaceDataImporter;
import org.eclipse.rcptt.resources.WorkspaceDataMaker;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSRoot;
import org.eclipse.rcptt.workspace.WorkspaceData;
import org.eclipse.rcptt.workspace.WorkspaceFactory;
import org.eclipse.rcptt.workspace.WorkspaceVerification;

public class WorkspaceVerificationMaker
extends DefaultVerificationMaker {
    private WorkspaceDataMaker maker = new WorkspaceDataMaker();

    public Verification create(Resource resource, VerificationType type, String name) {
        WorkspaceVerification verification = (WorkspaceVerification)super.create(resource, type, name);
        verification.setContent(WorkspaceFactory.eINSTANCE.createWSRoot());
        return verification;
    }

    public void makeExecutable(Verification verification, IQ7NamedElement source) throws ModelException {
        this.maker.makeSelfSufficientData((WorkspaceData)((WorkspaceVerification)verification), source.getModifiedPersistenceModel(), source);
    }

    public void captureContents(IVerification verifiacion, Verification data, IProgressMonitor monitor) throws CoreException {
        WorkspaceVerification verification = (WorkspaceVerification)data;
        WorkspaceDataImporter importer = new WorkspaceDataImporter((WorkspaceData)verification);
        IPersistenceModel model = verifiacion.getPersistenceModel();
        model.removeAll();
        try {
            WSRoot ownRoot = ((WorkspaceVerification)verifiacion.getNamedElement()).getContent();
            ownRoot.getProjects().clear();
            EList projects = verification.getContent().getProjects();
            if (projects.size() > 0) {
                monitor.beginTask("Copy projects...", projects.size());
                for (WSProject project : projects) {
                    WSProject ownProject = WSUtils.getProject((WSRoot)ownRoot, (String)project.getName(), (boolean)true);
                    ImportUtils.importFiles((WSFolder)ownProject, (EList)project.getFiles(), (IPersistenceModel)model, (WorkspaceDataImporter)importer);
                    ImportUtils.importFolders((WSFolder)ownProject, (EList)project.getFolders(), (IPersistenceModel)model, (WorkspaceDataImporter)importer);
                }
            }
        }
        catch (Exception e) {
            throw new CoreException(RcpttPlugin.createStatus((Throwable)e));
        }
    }
}

