/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.util.internal;

import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.reporting.util.internal.Plugin;
import org.eclipse.rcptt.util.StringUtils;
import org.w3c.dom.Document;

public class XMLUtils {
    public static Document createDocument() throws CoreException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e1) {
            throw new CoreException(Plugin.UTILS.createError((Throwable)e1));
        }
    }

    public static XMLStreamWriter createWriter(OutputStream stream) throws CoreException {
        try {
            return XMLOutputFactory.newInstance().createXMLStreamWriter(stream, "UTF-8");
        }
        catch (XMLStreamException e1) {
            throw new CoreException(Plugin.UTILS.createError((Throwable)e1));
        }
    }

    public static void closeWriter(XMLStreamWriter writer) {
        try {
            writer.close();
        }
        catch (RuntimeException ex) {
            Plugin.UTILS.log("Can't close XMLStreamWriter", (Throwable)ex);
        }
        catch (XMLStreamException ex) {
            Plugin.UTILS.log("Can't close XMLStreamWriter", (Throwable)ex);
        }
    }

    public static String toString(Document doc) throws CoreException {
        StreamResult result = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            throw new CoreException(Plugin.UTILS.createError((Throwable)ex));
        }
        return result.getWriter().toString();
    }

    public static byte[] toUtf8Bytes(String data) {
        return StringUtils.getUtf8Bytes((String)data);
    }
}

