/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.platform.internal.commands;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.platform.commands.SortBy;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class SortByService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        SortBy sb = (SortBy)command;
        final String field = sb.getField();
        List pipe = CoreUtils.readPipeContent((IPipe)context.getInput());
        Collections.sort(pipe, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof EObject) || !(o2 instanceof EObject)) {
                    return 0;
                }
                EObject eo1 = (EObject)o1;
                EObject eo2 = (EObject)o2;
                Object attr1 = SortByService.this.getAttrVal(eo1, field);
                Object attr2 = SortByService.this.getAttrVal(eo2, field);
                if (attr1 == null) {
                    return -1;
                }
                try {
                    if (attr1 instanceof Comparable) {
                        return ((Comparable)attr1).compareTo(attr2);
                    }
                }
                catch (Exception exception) {
                    return attr1.toString().compareTo(attr2 == null ? "" : attr2.toString());
                }
                return 0;
            }
        });
        for (Object o : pipe) {
            context.getOutput().write(o);
        }
        return Status.OK_STATUS;
    }

    private Object getAttrVal(EObject o, String name) {
        EAttribute e = this.findAttr(o, name);
        if (e == null) {
            return null;
        }
        return o.eGet((EStructuralFeature)e);
    }

    private EAttribute findAttr(EObject o, String name) {
        for (EAttribute e : o.eClass().getEAllAttributes()) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }
}

