/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.targetdefinition;

import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.targetdefinition.TargetEditor;
import org.eclipse.pde.internal.ui.editor.validation.ControlValidationUtility;
import org.eclipse.pde.internal.ui.editor.validation.TextValidator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class InformationSection
extends SectionPart {
    private Text fNameText;
    private TargetEditor fEditor;
    private TextValidator fNameTextValidator;
    private FormPage fPage;

    public InformationSection(FormPage page, Composite parent) {
        super(parent, page.getManagedForm().getToolkit(), 256);
        this.fPage = page;
        this.fEditor = (TargetEditor)page.getEditor();
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    private ITargetDefinition getTarget() {
        return this.fEditor.getTarget();
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        data.verticalAlignment = 128;
        data.horizontalSpan = 2;
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.InformationSection_0);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        client.setLayoutData((Object)new GridData(1808));
        this.fNameText = toolkit.createText(client, this.getTarget().getName());
        this.fNameText.setLayoutData((Object)new GridData(768));
        this.fNameText.addModifyListener(e -> {
            String name;
            String value = this.fNameText.getText().trim();
            if (!value.equals(name = this.getTarget().getName())) {
                this.getTarget().setName(value.length() > 0 ? value : null);
                this.markDirty();
            }
        });
        this.fNameTextValidator = new TextValidator(this.fPage.getManagedForm(), this.fNameText, null, true){

            @Override
            protected boolean autoEnable() {
                return this.getText().getEditable();
            }

            @Override
            protected boolean validateControl() {
                return ControlValidationUtility.validateRequiredField(InformationSection.this.fNameText.getText(), InformationSection.this.fNameTextValidator, 3);
            }
        };
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
    }

    public void refresh() {
        this.fNameText.setText(this.getTarget().getName() != null ? this.getTarget().getName() : "");
        super.refresh();
    }
}

