/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.debug.runtime;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.rcptt.ecl.debug.runtime.SuspendListener;

public enum SuspendManager {
    INSTANCE;

    private final CopyOnWriteArrayList<SuspendListener> listeners = new CopyOnWriteArrayList();

    public void addListener(SuspendListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SuspendListener listener) {
        this.listeners.remove(listener);
    }

    public void fireSuspend() {
        for (SuspendListener listener : this.listeners) {
            listener.suspend();
        }
    }

    public void fireResume() {
        for (SuspendListener listener : this.listeners) {
            listener.resume();
        }
    }
}

