/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.operations.internal.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.operations.Split;
import org.eclipse.rcptt.ecl.operations.internal.OperationsPlugin;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class SplitService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof Split)) {
            return Status.CANCEL_STATUS;
        }
        Split split = (Split)command;
        String input = split.getStr();
        String sep = split.getSep();
        PipeWriter writer = new PipeWriter(context.getOutput(), split.isTrimResults(), split.isOmitEmptyStrings());
        int sepLength = sep.length();
        if (sepLength == 0) {
            throw new CoreException(OperationsPlugin.createErr("Empty separator is not allowed", new Object[0]));
        }
        int searchStart = 0;
        while (true) {
            int sepStart;
            if ((sepStart = input.indexOf(sep, searchStart)) == -1) break;
            writer.write(input.substring(searchStart, sepStart));
            searchStart = sepStart + sepLength;
        }
        writer.write(input.substring(searchStart));
        return Status.OK_STATUS;
    }

    private static class PipeWriter {
        private boolean trim;
        private boolean omit;
        private IPipe out;

        public PipeWriter(IPipe out, boolean trim, boolean omit) {
            this.out = out;
            this.trim = trim;
            this.omit = omit;
        }

        public void write(String result) throws CoreException {
            if (result.length() == 0 && this.omit) {
                return;
            }
            if (this.trim) {
                result = result.trim();
            }
            this.out.write((Object)result);
        }
    }
}

