/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.jface.text;

import java.lang.reflect.Field;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rcptt.tesla.core.Q7WaitUtils;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.core.TeslaMessages;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.BooleanResponse;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.IElementProcessorMapper;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.ShowContentAssist;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.rcptt.tesla.jface.TextReconcilerManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class JFaceTextProcessor
implements ITeslaCommandProcessor {
    private AbstractTeslaClient client;
    private WeakHashMap<AbstractReconciler, Long> reconcilerTimeours = new WeakHashMap();

    public int getPriority() {
        return 150;
    }

    public String getFeatureID() {
        return "jface.text";
    }

    public boolean isSelectorSupported(String kind) {
        return false;
    }

    public SelectResponse select(SelectCommand cmd, ElementGenerator generator, IElementProcessorMapper mapper) {
        return null;
    }

    public boolean isCommandSupported(Command cmd) {
        return cmd instanceof ShowContentAssist;
    }

    public Response executeCommand(Command command, IElementProcessorMapper mapper) {
        if (command instanceof ShowContentAssist) {
            return this.handleShowContentAssist((ShowContentAssist)command);
        }
        return null;
    }

    private Response handleShowContentAssist(ShowContentAssist command) {
        SWTUIElement swtuiElement = (SWTUIElement)this.getSWTProcessor().getMapper().get(command.getElement());
        BooleanResponse response = ProtocolFactory.eINSTANCE.createBooleanResponse();
        if (swtuiElement != null) {
            Viewer thisControl;
            Widget widget = PlayerWrapUtils.unwrapWidget((SWTUIElement)swtuiElement);
            if (widget instanceof StyledText && (thisControl = TeslaSWTAccess.getViewer((Control)((StyledText)widget))) != null && thisControl instanceof SourceViewer) {
                SourceViewer textViewer = (SourceViewer)thisControl;
                textViewer.doOperation(13);
            }
        } else {
            response.setMessage(TeslaMessages.CommandProcessor_CannotFindWidget);
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    private SWTUIProcessor getSWTProcessor() {
        return (SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class);
    }

    public ITeslaCommandProcessor.PreExecuteStatus preExecute(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        return null;
    }

    public void initialize(AbstractTeslaClient client, String id) {
        this.client = client;
    }

    public void postSelect(Element element, IElementProcessorMapper mapper) {
        if (element.getKind().equals(ElementKind.Text.name())) {
            mapper.map(element, (ITeslaCommandProcessor)this);
        }
    }

    public boolean isInactivityRequired() {
        return false;
    }

    public boolean canProceed(ContextManagement.Context context, Q7WaitInfoRoot info) {
        List reconcilers = TextReconcilerManager.getInstance().getReconcilers();
        for (AbstractReconciler reconciler : reconcilers) {
            try {
                boolean needWait = false;
                Field threadField = AbstractReconciler.class.getDeclaredField("fThread");
                threadField.setAccessible(true);
                Thread threadObject = (Thread)threadField.get(reconciler);
                if (threadObject != null) {
                    Thread.State state = threadObject.getState();
                    if (!(state.equals((Object)Thread.State.BLOCKED) || state.equals((Object)Thread.State.WAITING) || state.equals((Object)Thread.State.TIMED_WAITING) || state.equals((Object)Thread.State.TERMINATED))) {
                        Q7WaitUtils.updateInfo((String)"reconciler.thread", (String)reconciler.getClass().getName(), (Q7WaitInfoRoot)info);
                        needWait = true;
                    } else {
                        Field field = threadObject.getClass().getDeclaredField("fIsDirty");
                        field.setAccessible(true);
                        boolean fDirty = field.getBoolean(threadObject);
                        field = threadObject.getClass().getDeclaredField("fCanceled");
                        field.setAccessible(true);
                        boolean fCanceled = field.getBoolean(threadObject);
                        if (fDirty && !fCanceled) {
                            Q7WaitUtils.updateInfo((String)"reconciler.thread.dirty", (String)reconciler.getClass().getName(), (Q7WaitInfoRoot)info);
                            needWait = true;
                        }
                    }
                }
                if (!needWait) continue;
                Long firstTime = this.reconcilerTimeours.get(reconciler);
                if (firstTime == null) {
                    this.reconcilerTimeours.put(reconciler, System.currentTimeMillis());
                } else if (System.currentTimeMillis() - firstTime > TeslaLimits.getReconcilerTimeout()) {
                    Q7WaitUtils.updateInfo((String)"reconciler.thread.skip", (String)reconciler.getClass().getName(), (Q7WaitInfoRoot)info);
                    return true;
                }
                return false;
            }
            catch (Throwable e) {
                TeslaCore.log((Throwable)e);
            }
        }
        return true;
    }

    public void clean() {
        this.reconcilerTimeours.clear();
    }

    public void terminate() {
        this.client = null;
    }

    public void checkHang() {
    }

    public void collectInformation(AdvancedInformation information, Command lastCommand) {
    }

    public void notifyUI() {
    }
}

