/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.script;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.ecl.context.EclContext;
import org.eclipse.rcptt.core.persistence.plain.IPlainTextPersistenceExtension;
import org.eclipse.rcptt.core.persistence.plain.PlainTextPersistenceModel;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.util.FileUtil;

public class EclContextPlainExtension
implements IPlainTextPersistenceExtension {
    private static final String ECL_CONTEXT = ".ecl.context";

    public boolean isContentEntryOptional(EList<EObject> contents) {
        return contents.get(0) instanceof EclContext;
    }

    public void updateAttributes(PlainTextPersistenceModel plainTextPersistenceModel, Map<String, String> masterAttributes, EObject eObject) {
        EclContext ctx;
        Script script;
        if (eObject instanceof EclContext && (script = (ctx = (EclContext)eObject).getScript()) != null) {
            String content = script.getContent();
            OutputStream store = plainTextPersistenceModel.store(ECL_CONTEXT);
            try {
                try {
                    store.write(content.getBytes("utf-8"));
                }
                catch (IOException e) {
                    RcpttPlugin.log((Throwable)e);
                    FileUtil.safeClose((Closeable)store);
                }
            }
            finally {
                FileUtil.safeClose((Closeable)store);
            }
        }
    }

    public void updateMetadata(PlainTextPersistenceModel plainTextPersistenceModel, Map<String, String> header, EObject eObject) {
        InputStream stream;
        if (eObject instanceof EclContext && (stream = plainTextPersistenceModel.read(ECL_CONTEXT)) != null) {
            try {
                try {
                    byte[] content = FileUtil.getStreamContent((InputStream)stream);
                    Script sc = CoreFactory.eINSTANCE.createScript();
                    sc.setContent(new String(content, "utf-8"));
                    ((EclContext)eObject).setScript(sc);
                }
                catch (IOException e) {
                    RcpttPlugin.log((Throwable)e);
                    FileUtil.safeClose((Closeable)stream);
                }
            }
            finally {
                FileUtil.safeClose((Closeable)stream);
            }
        }
    }

    public void performObjectPreSaveUpdate(EObject eObject) {
        if (eObject instanceof EclContext) {
            ((EclContext)eObject).setScript(null);
        }
    }

    public String getTextContentType(String fName) {
        if (ECL_CONTEXT.equals(fName)) {
            return "text/ecl";
        }
        return null;
    }
}

