/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class FileSystemResolver {
    private Map<String, Scheme> registry = new HashMap<String, Scheme>();

    public static String unprefix(String prefix, String value) {
        return value.startsWith(prefix) ? value.substring(prefix.length()) : null;
    }

    public static String normalizeSlashes(String path) {
        if ((path = path.replace('\\', '/')).length() > 0 && !path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        return path;
    }

    public void register(Scheme scheme) {
        this.registry.put(scheme.getPrefix(), scheme);
    }

    public String resolve(String path) {
        for (Scheme s : this.registry.values()) {
            String result = s.resolve(path);
            if (result == null) continue;
            return result;
        }
        if (path.indexOf(58) < 2) {
            return path;
        }
        return null;
    }

    public boolean isDirectory(String path) {
        String resolvedPath;
        if (path != null && (resolvedPath = this.resolve(path)) != null) {
            try {
                File file = new File(resolvedPath);
                return file.isDirectory();
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return false;
    }

    public String make(String path) {
        String best = null;
        int bestLength = 0;
        for (Scheme s : this.registry.values()) {
            String result = s.make(path);
            if (result == null) continue;
            String candidate = FileSystemResolver.unprefix(s.getPrefix(), result);
            if (best != null && candidate.length() >= bestLength) continue;
            best = result;
            bestLength = candidate.length();
        }
        return best;
    }

    public static interface Scheme {
        public String getPrefix();

        public String resolve(String var1);

        public String make(String var1);
    }
}

