/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.filesystem.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rcptt.ui.commons.OneSelectionListener;
import org.eclipse.rcptt.util.FileSystemResolver;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FilesystemContentRootPathDialog
extends Dialog {
    Text rootText;
    String rootPath;
    FileSystemResolver resolver;

    protected FilesystemContentRootPathDialog(Shell parentShell, String path, FileSystemResolver resolver) {
        super(parentShell);
        this.rootPath = path;
        this.resolver = resolver;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public String getRootpath() {
        return this.rootPath;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMinimumSize(550, 140);
        newShell.setText("Configure correct root path");
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.rootPath != null) {
            this.rootText.setText(this.rootPath);
        }
        this.validate();
        return control;
    }

    protected void okPressed() {
        this.rootPath = this.rootText.getText();
        super.okPressed();
    }

    private void validate() {
        this.getButton(0).setEnabled(this.resolver.isDirectory(this.rootText.getText()));
    }

    protected Point getInitialSize() {
        return new Point(550, 140);
    }

    protected Control createDialogArea(final Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 3;
        composite.setLayoutData((Object)new GridData(1808));
        Label rootLabel = new Label(composite, 16448);
        rootLabel.setText("Root path:");
        this.rootText = new Text(composite, 2048);
        this.rootText.setLayoutData((Object)new GridData(768));
        this.rootText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilesystemContentRootPathDialog.this.validate();
            }
        });
        Button browseButton = new Button(composite, 8);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener((SelectionListener)new OneSelectionListener(){

            public void selected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell());
                String result = dialog.open();
                if (result != null) {
                    FilesystemContentRootPathDialog.this.rootText.setText(FilesystemContentRootPathDialog.this.resolver.make(result));
                }
            }
        });
        return composite;
    }
}

