/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.core.model.index.AbstractJob;
import org.eclipse.rcptt.internal.core.model.index.IProjectIndexer;
import org.eclipse.rcptt.internal.core.model.index.Index;
import org.eclipse.rcptt.internal.core.model.index.ReadWriteMonitor;

public abstract class IndexRequest
extends AbstractJob {
    private IProjectIndexer indexer;

    public IndexRequest(IProjectIndexer indexer) {
        this.indexer = indexer;
    }

    public IProjectIndexer.Internal getIndexer() {
        return (IProjectIndexer.Internal)this.indexer;
    }

    protected String[] queryDocumentNames(Index index) throws IOException {
        ReadWriteMonitor monitor = index.monitor;
        monitor.enterRead();
        try {
            String[] stringArray = index.queryDocumentNames();
            return stringArray;
        }
        finally {
            monitor.exitRead();
        }
    }

    protected Map<String, IQ7NamedElement> collectElementPaths(Collection<IQ7NamedElement> elements) {
        HashMap<String, IQ7NamedElement> paths = new HashMap<String, IQ7NamedElement>();
        for (IQ7NamedElement element : elements) {
            paths.put(element.getPath().removeFirstSegments(1).toString(), element);
        }
        return paths;
    }

    protected List<Object> checkChanges(Index index, Collection<IQ7NamedElement> elements, boolean clearOther) throws ModelException, IOException {
        String[] documents = this.queryDocumentNames(index);
        if (documents != null && documents.length != 0) {
            ArrayList<Object> changes = new ArrayList<Object>();
            Map<String, IQ7NamedElement> elementPaths = this.collectElementPaths(elements);
            int i = 0;
            while (i < documents.length) {
                String document = documents[i];
                IQ7NamedElement element = elementPaths.remove(document);
                if (element == null) {
                    if (clearOther) {
                        changes.add(document);
                    }
                } else {
                    long documentStamp;
                    long stamp;
                    IResource resource = element.getResource();
                    if (resource != null && resource.isAccessible() && (stamp = resource.getModificationStamp()) != (documentStamp = index.getModificationStamp(document))) {
                        changes.add(element);
                    }
                }
                ++i;
            }
            if (!elementPaths.isEmpty()) {
                changes.addAll(elementPaths.values());
            }
            return changes;
        }
        return new ArrayList<Object>(elements);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.indexer == null ? 0 : this.indexer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexRequest other = (IndexRequest)obj;
        return !(this.indexer == null ? other.indexer != null : !this.indexer.equals(other.indexer));
    }
}

