/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.sshd.RepeatingFilePasswordProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;

public class PasswordProviderWrapper
implements RepeatingFilePasswordProvider {
    private final KeyPasswordProvider delegate;
    private Map<String, AtomicInteger> counts = new ConcurrentHashMap<String, AtomicInteger>();

    public PasswordProviderWrapper(@NonNull KeyPasswordProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public void setAttempts(int numberOfPasswordPrompts) {
        this.delegate.setAttempts(numberOfPasswordPrompts);
    }

    @Override
    public int getAttempts() {
        return this.delegate.getAttempts();
    }

    public String getPassword(String resourceKey) throws IOException {
        int attempt = this.counts.computeIfAbsent(resourceKey, k -> new AtomicInteger()).get();
        char[] passphrase = this.delegate.getPassphrase(this.toUri(resourceKey), attempt);
        if (passphrase == null) {
            return null;
        }
        try {
            String string = new String(passphrase);
            return string;
        }
        finally {
            Arrays.fill(passphrase, '\u0000');
        }
    }

    @Override
    public RepeatingFilePasswordProvider.ResourceDecodeResult handleDecodeAttemptResult(String resourceKey, String password, Exception err) throws IOException, GeneralSecurityException {
        AtomicInteger count = this.counts.get(resourceKey);
        int numberOfAttempts = count == null ? 0 : count.incrementAndGet();
        RepeatingFilePasswordProvider.ResourceDecodeResult result = null;
        try {
            result = this.delegate.keyLoaded(this.toUri(resourceKey), numberOfAttempts, err) ? RepeatingFilePasswordProvider.ResourceDecodeResult.RETRY : RepeatingFilePasswordProvider.ResourceDecodeResult.TERMINATE;
        }
        finally {
            if (result != RepeatingFilePasswordProvider.ResourceDecodeResult.RETRY) {
                this.counts.remove(resourceKey);
            }
        }
        return result;
    }

    private URIish toUri(String resourceKey) {
        try {
            return new URIish(resourceKey);
        }
        catch (URISyntaxException e) {
            return new URIish().setPath(resourceKey);
        }
    }
}

