/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.aut;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.rcptt.internal.launching.aut.BaseAut;
import org.eclipse.rcptt.launching.Aut;

public class AutStorage {
    private List<BaseAut> auts = new ArrayList<BaseAut>();
    private Map<String, BaseAut> byName = new HashMap<String, BaseAut>();
    private Map<ILaunchConfiguration, BaseAut> byConfig = new HashMap<ILaunchConfiguration, BaseAut>();

    public synchronized List<Aut> getAll() {
        return new ArrayList<Aut>(this.auts);
    }

    public synchronized void add(BaseAut aut) {
        this.auts.add(aut);
        this.byName.put(aut.getName(), aut);
        this.byConfig.put(aut.getConfig(), aut);
    }

    public synchronized void remove(Aut aut) {
        this.auts.remove(aut);
        this.byName.remove(aut.getName());
        this.byConfig.remove(aut.getConfig());
    }

    public synchronized BaseAut removeByLaunch(ILaunchConfiguration config) {
        BaseAut aut = this.getByLaunch(config);
        if (aut != null) {
            this.remove(aut);
        }
        return aut;
    }

    public synchronized BaseAut getByName(String name) {
        return this.byName.get(name);
    }

    public BaseAut getByLaunch(ILaunch launch) {
        return this.getByLaunch(launch.getLaunchConfiguration());
    }

    public synchronized BaseAut getByLaunch(ILaunchConfiguration config) {
        return this.byConfig.get(this.shell(config));
    }

    private ILaunchConfiguration shell(ILaunchConfiguration config) {
        if (config instanceof ILaunchConfigurationWorkingCopy) {
            config = ((ILaunchConfigurationWorkingCopy)config).getOriginal();
        }
        return config;
    }
}

