/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.AbstractIoServiceFactoryFactory;
import org.apache.sshd.common.io.BuiltinIoServiceFactoryFactories;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.threads.ExecutorServiceConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIoServiceFactoryFactory
extends AbstractIoServiceFactoryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIoServiceFactoryFactory.class);
    private IoServiceFactoryFactory factory;

    protected DefaultIoServiceFactoryFactory() {
        this(null, true);
    }

    protected DefaultIoServiceFactoryFactory(ExecutorService executors, boolean shutdownOnExit) {
        super(executors, shutdownOnExit);
    }

    @Override
    public IoServiceFactory create(FactoryManager manager) {
        IoServiceFactoryFactory factoryInstance = this.getIoServiceProvider();
        return factoryInstance.create(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoServiceFactoryFactory getIoServiceProvider() {
        DefaultIoServiceFactoryFactory defaultIoServiceFactoryFactory = this;
        synchronized (defaultIoServiceFactoryFactory) {
            if (this.factory == null) {
                this.factory = DefaultIoServiceFactoryFactory.newInstance(IoServiceFactoryFactory.class);
                if (this.factory instanceof ExecutorServiceConfigurer) {
                    ExecutorServiceConfigurer configurer = (ExecutorServiceConfigurer)((Object)this.factory);
                    configurer.setExecutorService(this.getExecutorService());
                    configurer.setShutdownOnExit(this.isShutdownOnExit());
                }
            }
        }
        return this.factory;
    }

    public static <T extends IoServiceFactoryFactory> T newInstance(Class<T> clazz) {
        T t;
        T t2;
        String factory = System.getProperty(clazz.getName());
        if (!GenericUtils.isEmpty(factory)) {
            return DefaultIoServiceFactoryFactory.newInstance(clazz, factory);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        if (cl != null && (t2 = DefaultIoServiceFactoryFactory.tryLoad(ServiceLoader.load(clazz, cl))) != null) {
            return t2;
        }
        ClassLoader clDefault = DefaultIoServiceFactoryFactory.class.getClassLoader();
        if (cl != clDefault && (t = DefaultIoServiceFactoryFactory.tryLoad(ServiceLoader.load(clazz, clDefault))) != null) {
            return t;
        }
        throw new IllegalStateException("Could not find a valid sshd io provider");
    }

    public static <T extends IoServiceFactoryFactory> T tryLoad(ServiceLoader<T> loader) {
        Iterator<T> it = loader.iterator();
        try {
            while (it.hasNext()) {
                try {
                    return (T)((IoServiceFactoryFactory)it.next());
                }
                catch (Throwable t) {
                    LOGGER.trace("Exception while loading factory from ServiceLoader", t);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.trace("Exception while loading factory from ServiceLoader", t);
        }
        return null;
    }

    public static <T extends IoServiceFactoryFactory> T newInstance(Class<T> clazz, String factory) {
        ClassLoader clDefault;
        BuiltinIoServiceFactoryFactories builtin = BuiltinIoServiceFactoryFactories.fromFactoryName(factory);
        if (builtin != null) {
            IoServiceFactoryFactory builtinInstance = builtin.create();
            return (T)((IoServiceFactoryFactory)clazz.cast(builtinInstance));
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        if (cl != null) {
            try {
                Class<?> loaded = cl.loadClass(factory);
                Object factoryInstance = loaded.newInstance();
                return (T)((IoServiceFactoryFactory)clazz.cast(factoryInstance));
            }
            catch (Throwable t) {
                LOGGER.trace("Exception while loading factory " + factory, t);
            }
        }
        if (cl != (clDefault = DefaultIoServiceFactoryFactory.class.getClassLoader())) {
            try {
                Class<?> loaded = clDefault.loadClass(factory);
                Object factoryInstance = loaded.newInstance();
                return (T)((IoServiceFactoryFactory)clazz.cast(factoryInstance));
            }
            catch (Throwable t) {
                LOGGER.trace("Exception while loading factory " + factory, t);
            }
        }
        throw new IllegalStateException("Unable to create instance of class " + factory);
    }

    public static DefaultIoServiceFactoryFactory getDefaultIoServiceFactoryFactoryInstance() {
        return LazyDefaultIoServiceFactoryFactoryHolder.INSTANCE;
    }

    private static class LazyDefaultIoServiceFactoryFactoryHolder {
        private static final DefaultIoServiceFactoryFactory INSTANCE = new DefaultIoServiceFactoryFactory();

        private LazyDefaultIoServiceFactoryFactoryHolder() {
        }
    }
}

