/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;

@FunctionalInterface
public interface PrivateKeyEntryResolver {
    public static final PrivateKeyEntryResolver IGNORING = new PrivateKeyEntryResolver(){

        @Override
        public PrivateKey resolve(String keyType, byte[] keyData) throws IOException, GeneralSecurityException {
            return null;
        }

        public String toString() {
            return "IGNORING";
        }
    };
    public static final PrivateKeyEntryResolver FAILING = new PrivateKeyEntryResolver(){

        @Override
        public PrivateKey resolve(String keyType, byte[] keyData) throws IOException, GeneralSecurityException {
            throw new InvalidKeySpecException("Failing resolver on key type=" + keyType);
        }

        public String toString() {
            return "FAILING";
        }
    };

    public PrivateKey resolve(String var1, byte[] var2) throws IOException, GeneralSecurityException;
}

