/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.StashDropOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitEditorInput;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class StashDropCommand
extends RepositoriesViewCommandHandler<StashedCommitNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final List nodes = this.getSelectedNodes(event);
        if (nodes.isEmpty()) {
            return null;
        }
        final Repository repo = ((StashedCommitNode)nodes.get(0)).getRepository();
        if (repo == null) {
            return null;
        }
        final AtomicBoolean confirmed = new AtomicBoolean();
        final Shell shell = this.getActiveShell(event);
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String message;
                if (nodes.size() > 1) {
                    message = MessageFormat.format(UIText.StashDropCommand_confirmMultiple, Integer.toString(nodes.size()));
                } else {
                    StashedCommitNode commit = (StashedCommitNode)nodes.get(0);
                    message = MessageFormat.format(UIText.StashDropCommand_confirmSingle, Integer.toString(commit.getIndex()), ((RevCommit)commit.getObject()).getShortMessage());
                }
                String[] buttonLabels = new String[]{UIText.StashDropCommand_buttonDelete, IDialogConstants.CANCEL_LABEL};
                MessageDialog confirmDialog = new MessageDialog(shell, UIText.StashDropCommand_confirmTitle, null, message, 5, buttonLabels, 0);
                confirmed.set(confirmDialog.open() == 0);
            }
        });
        if (!confirmed.get()) {
            return null;
        }
        Job job = new Job(UIText.StashDropCommand_jobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(UIText.StashDropCommand_jobTitle, nodes.size());
                Collections.sort(nodes, new Comparator<StashedCommitNode>(){

                    @Override
                    public int compare(StashedCommitNode n1, StashedCommitNode n2) {
                        return n1.getIndex() < n2.getIndex() ? 1 : -1;
                    }
                });
                for (StashedCommitNode node : nodes) {
                    int index = node.getIndex();
                    if (index < 0) {
                        return null;
                    }
                    RevCommit commit = (RevCommit)node.getObject();
                    if (commit == null) {
                        return null;
                    }
                    String stashName = ((RevCommit)node.getObject()).getName();
                    StashDropOperation op = new StashDropOperation(repo, node.getIndex());
                    monitor.subTask(stashName);
                    try {
                        op.execute(monitor);
                    }
                    catch (CoreException e) {
                        Activator.logError(MessageFormat.format(UIText.StashDropCommand_dropFailed, ((RevCommit)node.getObject()).name()), e);
                    }
                    this.tryToCloseEditor(node);
                    monitor.worked(1);
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            private void tryToCloseEditor(final StashedCommitNode node) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IEditorReference[] editorReferences;
                        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
                        int n = editorReferences.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CommitEditorInput comEditorInput;
                            IEditorReference editorReference = iEditorReferenceArray[n2];
                            IEditorInput editorInput = null;
                            try {
                                editorInput = editorReference.getEditorInput();
                            }
                            catch (PartInitException e) {
                                Activator.handleError(e.getMessage(), e, true);
                            }
                            if (editorInput instanceof CommitEditorInput && (comEditorInput = (CommitEditorInput)editorInput).getCommit().getRevCommit().equals((AnyObjectId)node.getObject())) {
                                activePage.closeEditor(editorReference.getEditor(false), false);
                            }
                            ++n2;
                        }
                    }
                });
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.STASH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(new StashDropOperation(repo, ((StashedCommitNode)nodes.get(0)).getIndex()).getSchedulingRule());
        job.schedule();
        return null;
    }
}

