/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.hooks;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.equinox.weaving.adaptors.IWeavingAdaptor;
import org.eclipse.equinox.weaving.adaptors.WeavingAdaptor;
import org.eclipse.equinox.weaving.adaptors.WeavingAdaptorFactory;
import org.eclipse.equinox.weaving.hooks.AbstractWeavingHook;
import org.eclipse.equinox.weaving.hooks.BaseWeavingBundleFile;
import org.eclipse.equinox.weaving.hooks.BundleAdaptorProvider;
import org.eclipse.equinox.weaving.hooks.SupplementBundleListener;
import org.eclipse.equinox.weaving.hooks.WeavingBundleEntry;
import org.eclipse.equinox.weaving.hooks.WeavingBundleFile;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class WeavingHook
extends AbstractWeavingHook {
    private final WeavingAdaptorFactory adaptorFactory;
    private final Map<Long, IWeavingAdaptor> adaptors;
    private BundleContext bundleContext;

    public WeavingHook() {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJHook.<init>()");
        }
        this.adaptorFactory = new WeavingAdaptorFactory();
        this.adaptors = new HashMap<Long, IWeavingAdaptor>();
    }

    public void frameworkStart(BundleContext bundleContext) throws BundleException {
        this.initialize(bundleContext);
    }

    public void frameworkStop(BundleContext bundleContext) throws BundleException {
        this.adaptorFactory.dispose(bundleContext);
    }

    public IWeavingAdaptor getAdaptor(long l) {
        return this.adaptors.get(l);
    }

    public IWeavingAdaptor getHostBundleAdaptor(long l) {
        Bundle bundle;
        Bundle bundle2 = this.bundleContext.getBundle(l);
        if (bundle2 != null && (bundle = this.adaptorFactory.getHost(bundle2)) != null) {
            long l2 = bundle.getBundleId();
            return this.adaptors.get(l2);
        }
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData baseData) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.initializedClassLoader() bundle=" + baseData.getSymbolicName() + ", loader=" + baseClassLoader + ", data=" + baseData + ", bundleFile=" + baseData.getBundleFile());
        }
        IWeavingAdaptor iWeavingAdaptor = this.createAspectJAdaptor(baseData);
        iWeavingAdaptor.setBaseClassLoader(baseClassLoader);
        iWeavingAdaptor.initialize();
        this.adaptors.put(baseData.getBundleID(), iWeavingAdaptor);
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.initializedClassLoader() adaptor=" + iWeavingAdaptor);
        }
    }

    public byte[] processClass(String string, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        WeavingBundleEntry weavingBundleEntry;
        byte[] byArray2 = null;
        if (bundleEntry instanceof WeavingBundleEntry && !(weavingBundleEntry = (WeavingBundleEntry)bundleEntry).dontWeave()) {
            IWeavingAdaptor iWeavingAdaptor = weavingBundleEntry.getAdaptor();
            byArray2 = iWeavingAdaptor.weaveClass(string, byArray);
        }
        return byArray2;
    }

    public void recordClassDefine(String string, Class clazz, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        WeavingBundleEntry weavingBundleEntry;
        if (clazz == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Error in defining class: " + string);
            }
            return;
        }
        if (bundleEntry instanceof WeavingBundleEntry && !(weavingBundleEntry = (WeavingBundleEntry)bundleEntry).dontWeave()) {
            IWeavingAdaptor iWeavingAdaptor = weavingBundleEntry.getAdaptor();
            URL uRL = weavingBundleEntry.getBundleFileURL();
            iWeavingAdaptor.storeClass(string, uRL, clazz, byArray);
        }
    }

    public void resetAdaptor(long l) {
        this.adaptors.remove(l);
    }

    public BundleFile wrapBundleFile(BundleFile bundleFile, Object object, BaseData baseData, boolean bl) throws IOException {
        WeavingBundleFile weavingBundleFile = null;
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("> AspectJBundleFileWrapperFactoryHook.wrapBundleFile() bundle=" + baseData.getSymbolicName() + " bundleFile=" + bundleFile + ", content=" + object + ", data=" + baseData + ", base=" + bl + ", baseFile=" + bundleFile.getBaseFile());
        }
        weavingBundleFile = bl ? new BaseWeavingBundleFile(new BundleAdaptorProvider(baseData, this), bundleFile) : new WeavingBundleFile(new BundleAdaptorProvider(baseData, this), bundleFile);
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("< AspectJBundleFileWrapperFactoryHook.wrapBundleFile() wrapped=" + (Object)((Object)weavingBundleFile));
        }
        return weavingBundleFile;
    }

    private IWeavingAdaptor createAspectJAdaptor(BaseData baseData) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.createAspectJAdaptor() location=" + baseData.getLocation());
        }
        WeavingAdaptor weavingAdaptor = null;
        if (this.adaptorFactory != null) {
            weavingAdaptor = new WeavingAdaptor(baseData, this.adaptorFactory, null, null, null);
        } else if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJHook.createAspectJAdaptor() factory=" + this.adaptorFactory);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.createAspectJAdaptor() adaptor=" + weavingAdaptor);
        }
        return weavingAdaptor;
    }

    private void initialize(BundleContext bundleContext) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.initialize() context=" + bundleContext);
        }
        this.bundleContext = bundleContext;
        ISupplementerRegistry iSupplementerRegistry = this.getSupplementerRegistry();
        this.adaptorFactory.initialize(bundleContext, iSupplementerRegistry);
        ServiceReference serviceReference = bundleContext.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)bundleContext.getService(serviceReference);
        iSupplementerRegistry.setBundleContext(bundleContext);
        iSupplementerRegistry.setPackageAdmin(packageAdmin);
        bundleContext.addBundleListener((BundleListener)new SupplementBundleListener(iSupplementerRegistry));
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = 0;
        while (n < bundleArray.length) {
            iSupplementerRegistry.addSupplementer(bundleArray[n], false);
            ++n;
        }
        n = 0;
        while (n < bundleArray.length) {
            iSupplementerRegistry.addSupplementedBundle(bundleArray[n]);
            ++n;
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.initialize() adaptorFactory=" + this.adaptorFactory);
        }
    }
}

