/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.interop.internal.commands;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.interop.Invoke;
import org.eclipse.rcptt.ecl.interop.InvokeUi;
import org.eclipse.rcptt.ecl.interop.internal.EclInteropPlugin;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.util.DisplayUtils;
import org.eclipse.rcptt.util.DisplayUtilsProvider;

public class InvokeService
implements ICommandService {
    private static final Object NOT_CONVERTIBLE = new Object();

    public IStatus service(Command command, IProcess context) throws CoreException {
        Invoke cmd = (Invoke)command;
        final Object object = cmd.getObject();
        if (object == null) {
            return EclInteropPlugin.error("Null invocation target.");
        }
        Class<?> class_ = object.getClass();
        String name = cmd.getName();
        if (name == null || name.length() == 0) {
            return EclInteropPlugin.error("Empty method name.");
        }
        final Object[] args = cmd.getArgs().toArray();
        if (class_.isArray()) {
            return InvokeService.processArrayMethod(object, name, args, context.getOutput());
        }
        Object result = null;
        try {
            final Method method = InvokeService.matchMethod(class_, name, args);
            if (method == null) {
                if (args.length > 0) {
                    return EclInteropPlugin.error("Method not found.");
                }
                result = InvokeService.getFieldValue(class_, object, name);
            } else {
                DisplayUtils utils = DisplayUtilsProvider.getDisplayUtils();
                if (utils.isWidget(object) || cmd instanceof InvokeUi) {
                    FutureTask future = new FutureTask(new Callable(){

                        public Object call() throws Exception {
                            return method.invoke(object, args);
                        }
                    });
                    if (cmd.isNoResult() || method.getReturnType() == Void.TYPE) {
                        utils.asyncExec(object, future);
                        result = Status.OK_STATUS;
                    } else {
                        utils.syncExec(object, future);
                        result = future.get();
                    }
                } else {
                    result = method.invoke(object, args);
                }
            }
        }
        catch (Exception e) {
            return EclInteropPlugin.error(e, "%s: %s", e.getClass().getName(), e.getMessage());
        }
        if (result != null) {
            context.getOutput().write(result);
        }
        return Status.OK_STATUS;
    }

    private static Object getFieldValue(Class<?> class_, Object object, String name) throws CoreException {
        if (class_ == null) {
            throw new CoreException((IStatus)EclInteropPlugin.error("method or field not found"));
        }
        try {
            Field field = class_.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalArgumentException e) {
            throw new CoreException(EclInteropPlugin.error(e, "Unexpected error getting field %s", name));
        }
        catch (SecurityException e) {
            throw new CoreException(EclInteropPlugin.error(e, "Unexpected error getting field %s", name));
        }
        catch (IllegalAccessException e) {
            throw new CoreException(EclInteropPlugin.error(e, "Unexpected error getting field %s", name));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return InvokeService.getFieldValue(class_.getSuperclass(), object, name);
        }
    }

    private static IStatus processArrayMethod(Object array, String name, Object[] args, IPipe out) throws CoreException {
        if (name.equals("get")) {
            if (args.length != 1) {
                return EclInteropPlugin.error("Invalid number of arguments.");
            }
            Object index = InvokeService.convert(Integer.TYPE, args[0], true, true);
            if (index == NOT_CONVERTIBLE) {
                return EclInteropPlugin.error("Invalid index type.");
            }
            Object result = Array.get(array, (Integer)index);
            if (result != null) {
                out.write(result);
            }
            return Status.OK_STATUS;
        }
        if (name.equals("set")) {
            if (args.length != 2) {
                return EclInteropPlugin.error("Invalid number of arguments.");
            }
            Object index = InvokeService.convert(Integer.TYPE, args[0], true, true);
            if (index == NOT_CONVERTIBLE) {
                return EclInteropPlugin.error("Invalid index type.");
            }
            Object value = InvokeService.convert(array.getClass().getComponentType(), args[1], true, true);
            if (value == NOT_CONVERTIBLE) {
                return EclInteropPlugin.error("Invalid value type.");
            }
            Array.set(array, (Integer)index, value);
            return Status.OK_STATUS;
        }
        if (name.equals("length")) {
            if (args.length != 0) {
                return EclInteropPlugin.error("Invalid number of arguments.");
            }
            out.write((Object)Array.getLength(array));
            return Status.OK_STATUS;
        }
        return EclInteropPlugin.error("Unknown array pseudo-method name.");
    }

    static Method matchMethod(Class class_, String name, Object[] args) {
        Method result = InvokeService.matchMethod(class_, name, args, false, false);
        if (result == null) {
            result = InvokeService.matchMethod(class_, name, args, true, false);
        }
        if (result == null) {
            result = InvokeService.matchMethod(class_, name, args, true, true);
        }
        return result;
    }

    static Method matchMethod(Class class_, String name, Object[] args, boolean doWiden, boolean doNarrow) {
        Method[] methods;
        Method[] methodArray = methods = class_.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] paramTypes;
            Method m = methodArray[n2];
            if (m.getName().equals(name) && (paramTypes = m.getParameterTypes()).length == args.length) {
                boolean done = true;
                int i = 0;
                while (i < paramTypes.length) {
                    if (InvokeService.convert(paramTypes[i], args[i], doWiden, doNarrow) == NOT_CONVERTIBLE) {
                        done = false;
                        break;
                    }
                    ++i;
                }
                if (done) {
                    return m;
                }
            }
            ++n2;
        }
        return null;
    }

    private static Object convert(Class to, Object value, boolean doWiden, boolean doNarrow) {
        Object converted;
        Class from = value.getClass();
        if (to.isAssignableFrom(from)) {
            return value;
        }
        to = InvokeService.toPrimitive(to);
        from = InvokeService.toPrimitive(from);
        if (to == null || from == null) {
            return NOT_CONVERTIBLE;
        }
        if (to == from) {
            return value;
        }
        if (doWiden && (converted = InvokeService.widden(to, value)) != NOT_CONVERTIBLE) {
            return converted;
        }
        if (doNarrow && (converted = InvokeService.narrow(to, value)) != NOT_CONVERTIBLE) {
            return converted;
        }
        return NOT_CONVERTIBLE;
    }

    private static Object widden(Class to, Object value) {
        if (to == value.getClass()) {
            return value;
        }
        if (to == InvokeService.toPrimitive(value.getClass())) {
            return value;
        }
        Number number = null;
        Character character = null;
        if (value instanceof Number) {
            number = (Number)value;
        }
        if (value instanceof Character) {
            character = (Character)value;
        }
        if (to == Long.TYPE) {
            if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
                return new Long(number.longValue());
            }
            if (value instanceof Character) {
                return new Long(character.charValue());
            }
            return NOT_CONVERTIBLE;
        }
        if (to == Integer.TYPE) {
            if (value instanceof Byte || value instanceof Short) {
                return new Integer(number.intValue());
            }
            if (value instanceof Character) {
                return new Integer(character.charValue());
            }
            return NOT_CONVERTIBLE;
        }
        if (to == Short.TYPE) {
            if (value instanceof Byte) {
                return new Short(number.shortValue());
            }
            return NOT_CONVERTIBLE;
        }
        if (to == Byte.TYPE) {
            return NOT_CONVERTIBLE;
        }
        if (to == Double.TYPE) {
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float) {
                return new Double(number.doubleValue());
            }
            if (value instanceof Character) {
                return new Double(character.charValue());
            }
            return NOT_CONVERTIBLE;
        }
        if (to == Float.TYPE) {
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                return new Float(number.floatValue());
            }
            if (value instanceof Character) {
                return new Float(character.charValue());
            }
            return NOT_CONVERTIBLE;
        }
        if (to == Character.TYPE) {
            return NOT_CONVERTIBLE;
        }
        return NOT_CONVERTIBLE;
    }

    private static Object narrow(Class to, Object value) {
        if (to == value.getClass()) {
            return value;
        }
        if (to == InvokeService.toPrimitive(value.getClass())) {
            return value;
        }
        Number number = null;
        Character character = null;
        if (value instanceof Number) {
            number = (Number)value;
        }
        if (value instanceof Character) {
            character = (Character)value;
        }
        if (to == Long.TYPE) {
            if (value instanceof Number) {
                double d;
                long l = number.longValue();
                if ((double)l == (d = number.doubleValue()) && d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                    return new Long(l);
                }
                return NOT_CONVERTIBLE;
            }
            return NOT_CONVERTIBLE;
        }
        if (to == Integer.TYPE) {
            if (value instanceof Number) {
                double d;
                long l = number.longValue();
                if ((double)l == (d = number.doubleValue()) && l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                    return new Integer((int)l);
                }
                return NOT_CONVERTIBLE;
            }
            return NOT_CONVERTIBLE;
        }
        if (to == Short.TYPE) {
            if (value instanceof Number) {
                double d;
                long l = number.longValue();
                if ((double)l == (d = number.doubleValue()) && l >= -32768L && l <= 32767L) {
                    return new Short((short)l);
                }
                return NOT_CONVERTIBLE;
            }
            if (value instanceof Character) {
                char c = character.charValue();
                if (c >= Short.MIN_VALUE && c <= Short.MAX_VALUE) {
                    return new Short((short)c);
                }
                return NOT_CONVERTIBLE;
            }
            return NOT_CONVERTIBLE;
        }
        if (to == Byte.TYPE) {
            if (value instanceof Number) {
                double d;
                long l = number.longValue();
                if ((double)l == (d = number.doubleValue()) && l >= -128L && l <= 127L) {
                    return new Byte((byte)l);
                }
                return NOT_CONVERTIBLE;
            }
            if (value instanceof Character) {
                char c = character.charValue();
                if (c >= '\uffffff80' && c <= '\u007f') {
                    return new Byte((byte)c);
                }
                return NOT_CONVERTIBLE;
            }
            return NOT_CONVERTIBLE;
        }
        if (to == Double.TYPE) {
            return NOT_CONVERTIBLE;
        }
        if (to == Float.TYPE) {
            if (value instanceof Double) {
                double d = number.doubleValue();
                if (d >= (double)1.4E-45f && d <= 3.4028234663852886E38) {
                    return new Float((float)d);
                }
                return NOT_CONVERTIBLE;
            }
            return NOT_CONVERTIBLE;
        }
        if (to == Character.TYPE) {
            if (value instanceof Number) {
                double d;
                long l = number.longValue();
                if ((double)l == (d = number.doubleValue()) && l >= 0L && l <= 65535L) {
                    return new Character((char)l);
                }
                return NOT_CONVERTIBLE;
            }
            return NOT_CONVERTIBLE;
        }
        return NOT_CONVERTIBLE;
    }

    private static Class toPrimitive(Class boxed) {
        if (boxed.isPrimitive()) {
            return boxed;
        }
        if (boxed == Boolean.class) {
            return Boolean.TYPE;
        }
        if (boxed == Character.class) {
            return Character.TYPE;
        }
        if (boxed == Byte.class) {
            return Byte.TYPE;
        }
        if (boxed == Short.class) {
            return Short.TYPE;
        }
        if (boxed == Integer.class) {
            return Integer.TYPE;
        }
        if (boxed == Long.class) {
            return Long.TYPE;
        }
        if (boxed == Float.class) {
            return Float.TYPE;
        }
        if (boxed == Double.class) {
            return Double.TYPE;
        }
        return null;
    }
}

