/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.manipulation;

import java.util.jar.Attributes;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsMessages;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.Messages;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.osgi.util.NLS;

public class JavaElementLabelComposerCore {
    static final long QUALIFIER_FLAGS = 0x1002000000000L;
    protected static String fgPkgNamePrefix;
    protected static String fgPkgNamePostfix;
    protected static int fgPkgNameChars;
    protected static int fgPkgNameLength;
    protected final FlexibleBufferCore fBuffer;

    static {
        fgPkgNameLength = -1;
    }

    protected static final boolean getFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    public JavaElementLabelComposerCore(FlexibleBufferCore buffer) {
        this.fBuffer = buffer;
    }

    public JavaElementLabelComposerCore(StringBuffer buffer) {
        this(new FlexibleStringBufferCore(buffer));
    }

    public void appendElementLabel(IJavaElement element, long flags) {
        int type = element.getElementType();
        IPackageFragmentRoot root = null;
        if (type != 1 && type != 2 && type != 3) {
            root = JavaModelUtil.getPackageFragmentRoot(element);
        }
        if (root != null && JavaElementLabelComposerCore.getFlag(flags, 0x100000000000L)) {
            this.appendPackageFragmentRootLabel(root, 0x20000000000L);
            this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
        }
        switch (type) {
            case 9: {
                this.appendMethodLabel((IMethod)element, flags);
                break;
            }
            case 8: {
                this.appendFieldLabel((IField)element, flags);
                break;
            }
            case 14: {
                this.appendLocalVariableLabel((ILocalVariable)element, flags);
                break;
            }
            case 15: {
                this.appendTypeParameterLabel((ITypeParameter)element, flags);
                break;
            }
            case 10: {
                this.appendInitializerLabel((IInitializer)element, flags);
                break;
            }
            case 7: {
                this.appendTypeLabel((IType)element, flags);
                break;
            }
            case 6: {
                this.appendClassFileLabel((IClassFile)element, flags);
                break;
            }
            case 5: {
                this.appendCompilationUnitLabel((ICompilationUnit)element, flags);
                break;
            }
            case 4: {
                this.appendPackageFragmentLabel((IPackageFragment)element, flags);
                break;
            }
            case 3: {
                this.appendPackageFragmentRootLabel((IPackageFragmentRoot)element, flags);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.appendDeclarationLabel(element, flags);
                break;
            }
            case 1: 
            case 2: {
                this.fBuffer.append(element.getElementName());
                break;
            }
            default: {
                this.fBuffer.append(element.getElementName());
            }
        }
        if (root != null && JavaElementLabelComposerCore.getFlag(flags, 0x80000000000L)) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
            this.appendPackageFragmentRootLabel(root, 0x20000000000L);
            if (JavaElementLabelComposerCore.getFlag(flags, 0x80000000000000L)) {
                this.setQualifierStyle(offset);
            }
        }
    }

    protected void setQualifierStyle(int offset) {
    }

    protected void setDecorationsStyle(int offset) {
    }

    public void appendMethodLabel(IMethod method, long flags) {
        try {
            String[] types;
            BindingKey declaringType;
            String resolvedSig;
            BindingKey resolvedKey = JavaElementLabelComposerCore.getFlag(flags, 0x1000000000000L) && method.isResolved() ? new BindingKey(method.getKey()) : null;
            String string = resolvedSig = resolvedKey != null ? resolvedKey.toSignature() : null;
            if (JavaElementLabelComposerCore.getFlag(flags, 4L)) {
                ITypeParameter[] typeParameters;
                if (resolvedKey != null) {
                    if (resolvedKey.isParameterizedMethod()) {
                        String[] typeArgRefs = resolvedKey.getTypeArguments();
                        if (typeArgRefs.length > 0) {
                            this.appendTypeArgumentSignaturesLabel((IJavaElement)method, typeArgRefs, flags);
                            this.fBuffer.append(' ');
                        }
                    } else {
                        String[] typeParameterSigs = Signature.getTypeParameters((String)resolvedSig);
                        if (typeParameterSigs.length > 0) {
                            this.appendTypeParameterSignaturesLabel(typeParameterSigs, flags);
                            this.fBuffer.append(' ');
                        }
                    }
                } else if (method.exists() && (typeParameters = method.getTypeParameters()).length > 0) {
                    this.appendTypeParametersLabels(typeParameters, flags);
                    this.fBuffer.append(' ');
                }
            }
            if (JavaElementLabelComposerCore.getFlag(flags, 64L) && method.exists() && !method.isConstructor()) {
                String returnTypeSig = resolvedSig != null ? Signature.getReturnType((String)resolvedSig) : method.getReturnType();
                this.appendTypeSignatureLabel((IJavaElement)method, returnTypeSig, flags);
                this.fBuffer.append(' ');
            }
            if (JavaElementLabelComposerCore.getFlag(flags, 128L)) {
                this.appendTypeLabel(method.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
                this.fBuffer.append('.');
            }
            this.fBuffer.append(this.getElementName((IJavaElement)method));
            if (JavaElementLabelComposerCore.getFlag(flags, 0x200000L) && method.exists() && method.isConstructor() && resolvedSig != null && resolvedKey.isParameterizedType() && (declaringType = resolvedKey.getDeclaringType()) != null) {
                String[] declaringTypeArguments = declaringType.getTypeArguments();
                this.appendTypeArgumentSignaturesLabel((IJavaElement)method, declaringTypeArguments, flags);
            }
            this.fBuffer.append('(');
            String[] declaredParameterTypes = method.getParameterTypes();
            if (JavaElementLabelComposerCore.getFlag(flags, 3L)) {
                types = null;
                int nParams = 0;
                boolean renderVarargs = false;
                boolean isPolymorphic = false;
                if (JavaElementLabelComposerCore.getFlag(flags, 1L)) {
                    types = resolvedSig != null ? Signature.getParameterTypes((String)resolvedSig) : declaredParameterTypes;
                    nParams = types.length;
                    boolean bl = renderVarargs = method.exists() && Flags.isVarargs((int)method.getFlags());
                    if (renderVarargs && resolvedSig != null && declaredParameterTypes.length == 1 && JavaModelUtil.isPolymorphicSignature(method)) {
                        renderVarargs = false;
                        isPolymorphic = true;
                    }
                }
                String[] names = null;
                if (JavaElementLabelComposerCore.getFlag(flags, 2L) && method.exists()) {
                    names = method.getParameterNames();
                    if (!isPolymorphic) {
                        if (types == null) {
                            nParams = names.length;
                        } else if (nParams != names.length) {
                            if (resolvedSig != null && types.length > names.length) {
                                nParams = names.length;
                                String[] typesWithoutSyntheticParams = new String[nParams];
                                System.arraycopy(types, types.length - nParams, typesWithoutSyntheticParams, 0, nParams);
                                types = typesWithoutSyntheticParams;
                            } else {
                                names = null;
                            }
                        }
                    }
                }
                ILocalVariable[] annotatedParameters = null;
                if (nParams > 0 && JavaElementLabelComposerCore.getFlag(flags, 0x10000000000000L)) {
                    annotatedParameters = method.getParameters();
                }
                int i = 0;
                while (i < nParams) {
                    if (i > 0) {
                        this.fBuffer.append(JavaElementLabelsCore.COMMA_STRING);
                    }
                    if (annotatedParameters != null && i < annotatedParameters.length) {
                        this.appendAnnotationLabels(annotatedParameters[i].getAnnotations(), flags);
                    }
                    if (types != null) {
                        String paramSig = types[i];
                        if (renderVarargs && i == nParams - 1) {
                            int newDim = Signature.getArrayCount((String)paramSig) - 1;
                            this.appendTypeSignatureLabel((IJavaElement)method, Signature.getElementType((String)paramSig), flags);
                            int k = 0;
                            while (k < newDim) {
                                this.fBuffer.append('[').append(']');
                                ++k;
                            }
                            this.fBuffer.append("...");
                        } else {
                            this.appendTypeSignatureLabel((IJavaElement)method, paramSig, flags);
                        }
                    }
                    if (names != null) {
                        if (types != null) {
                            this.fBuffer.append(' ');
                        }
                        if (isPolymorphic) {
                            this.fBuffer.append(String.valueOf(names[0]) + i);
                        } else {
                            this.fBuffer.append(names[i]);
                        }
                    }
                    ++i;
                }
            } else if (declaredParameterTypes.length > 0) {
                this.fBuffer.append("...");
            }
            this.fBuffer.append(')');
            if (JavaElementLabelComposerCore.getFlag(flags, 16L)) {
                if (resolvedKey != null) {
                    types = resolvedKey.getThrownExceptions();
                } else {
                    String[] stringArray = types = method.exists() ? method.getExceptionTypes() : new String[]{};
                }
                if (types.length > 0) {
                    this.fBuffer.append(" throws ");
                    int i = 0;
                    while (i < types.length) {
                        if (i > 0) {
                            this.fBuffer.append(JavaElementLabelsCore.COMMA_STRING);
                        }
                        this.appendTypeSignatureLabel((IJavaElement)method, types[i], flags);
                        ++i;
                    }
                }
            }
            if (JavaElementLabelComposerCore.getFlag(flags, 8L)) {
                ITypeParameter[] typeParameters;
                int offset = this.fBuffer.length();
                if (resolvedKey != null) {
                    if (resolvedKey.isParameterizedMethod()) {
                        String[] typeArgRefs = resolvedKey.getTypeArguments();
                        if (typeArgRefs.length > 0) {
                            this.fBuffer.append(' ');
                            this.appendTypeArgumentSignaturesLabel((IJavaElement)method, typeArgRefs, flags);
                        }
                    } else {
                        String[] typeParameterSigs = Signature.getTypeParameters((String)resolvedSig);
                        if (typeParameterSigs.length > 0) {
                            this.fBuffer.append(' ');
                            this.appendTypeParameterSignaturesLabel(typeParameterSigs, flags);
                        }
                    }
                } else if (method.exists() && (typeParameters = method.getTypeParameters()).length > 0) {
                    this.fBuffer.append(' ');
                    this.appendTypeParametersLabels(typeParameters, flags);
                }
                if (JavaElementLabelComposerCore.getFlag(flags, 0x80000000000000L) && offset != this.fBuffer.length()) {
                    this.setDecorationsStyle(offset);
                }
            }
            if (JavaElementLabelComposerCore.getFlag(flags, 32L) && method.exists() && !method.isConstructor()) {
                int offset = this.fBuffer.length();
                this.fBuffer.append(JavaElementLabelsCore.DECL_STRING);
                String returnTypeSig = resolvedSig != null ? Signature.getReturnType((String)resolvedSig) : method.getReturnType();
                this.appendTypeSignatureLabel((IJavaElement)method, returnTypeSig, flags);
                if (JavaElementLabelComposerCore.getFlag(flags, 0x80000000000000L)) {
                    this.setDecorationsStyle(offset);
                }
            }
            if (JavaElementLabelComposerCore.getFlag(flags, 0x4000000000000L) && method.exists()) {
                this.appendCategoryLabel((IMember)method, flags);
            }
            if (JavaElementLabelComposerCore.getFlag(flags, 256L)) {
                int offset = this.fBuffer.length();
                this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
                this.appendTypeLabel(method.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
                if (JavaElementLabelComposerCore.getFlag(flags, 0x80000000000000L)) {
                    this.setQualifierStyle(offset);
                }
            }
        }
        catch (JavaModelException e) {
            JavaManipulationPlugin.logException("", e);
        }
    }

    protected void appendCategoryLabel(IMember member, long flags) throws JavaModelException {
    }

    protected void appendAnnotationLabels(IAnnotation[] annotations, long flags) throws JavaModelException {
        int j = 0;
        while (j < annotations.length) {
            IAnnotation annotation = annotations[j];
            this.appendAnnotationLabel(annotation, flags);
            this.fBuffer.append(' ');
            ++j;
        }
    }

    public void appendAnnotationLabel(IAnnotation annotation, long flags) throws JavaModelException {
        this.fBuffer.append('@');
        this.appendTypeSignatureLabel((IJavaElement)annotation, Signature.createTypeSignature((String)annotation.getElementName(), (boolean)false), flags);
        IMemberValuePair[] memberValuePairs = annotation.getMemberValuePairs();
        if (memberValuePairs.length == 0) {
            return;
        }
        this.fBuffer.append('(');
        int i = 0;
        while (i < memberValuePairs.length) {
            if (i > 0) {
                this.fBuffer.append(JavaElementLabelsCore.COMMA_STRING);
            }
            IMemberValuePair memberValuePair = memberValuePairs[i];
            this.fBuffer.append(this.getMemberName((IJavaElement)annotation, annotation.getElementName(), memberValuePair.getMemberName()));
            this.fBuffer.append('=');
            this.appendAnnotationValue(annotation, memberValuePair.getValue(), memberValuePair.getValueKind(), flags);
            ++i;
        }
        this.fBuffer.append(')');
    }

    public void appendAnnotationValue(IAnnotation annotation, Object value, int valueKind, long flags) throws JavaModelException {
        if (value instanceof Object[]) {
            this.fBuffer.append('{');
            Object[] values = (Object[])value;
            int j = 0;
            while (j < values.length) {
                if (j > 0) {
                    this.fBuffer.append(JavaElementLabelsCore.COMMA_STRING);
                }
                value = values[j];
                this.appendAnnotationValue(annotation, value, valueKind, flags);
                ++j;
            }
            this.fBuffer.append('}');
        } else {
            switch (valueKind) {
                case 11: {
                    this.appendTypeSignatureLabel((IJavaElement)annotation, Signature.createTypeSignature((String)((String)value), (boolean)false), flags);
                    this.fBuffer.append(".class");
                    break;
                }
                case 12: {
                    String name = (String)value;
                    int lastDot = name.lastIndexOf(46);
                    if (lastDot != -1) {
                        String type = name.substring(0, lastDot);
                        String field = name.substring(lastDot + 1);
                        this.appendTypeSignatureLabel((IJavaElement)annotation, Signature.createTypeSignature((String)type, (boolean)false), flags);
                        this.fBuffer.append('.');
                        this.fBuffer.append(this.getMemberName((IJavaElement)annotation, type, field));
                        break;
                    }
                }
                case 10: {
                    this.appendAnnotationLabel((IAnnotation)value, flags);
                    break;
                }
                case 9: {
                    this.fBuffer.append(ASTNodes.getEscapedStringLiteral((String)value));
                    break;
                }
                case 4: {
                    this.fBuffer.append(ASTNodes.getEscapedCharacterLiteral(((Character)value).charValue()));
                    break;
                }
                default: {
                    this.fBuffer.append(String.valueOf(value));
                }
            }
        }
    }

    private void appendTypeParametersLabels(ITypeParameter[] typeParameters, long flags) throws JavaModelException {
        if (typeParameters.length > 0) {
            this.fBuffer.append(this.getLT());
            int i = 0;
            while (i < typeParameters.length) {
                if (i > 0) {
                    this.fBuffer.append(JavaElementLabelsCore.COMMA_STRING);
                }
                this.appendTypeParameterWithBounds(typeParameters[i], flags);
                ++i;
            }
            this.fBuffer.append(this.getGT());
        }
    }

    public void appendFieldLabel(IField field, long flags) {
        try {
            int offset;
            if (JavaElementLabelComposerCore.getFlag(flags, 32768L) && field.exists() && !Flags.isEnum((int)field.getFlags())) {
                if (JavaElementLabelComposerCore.getFlag(flags, 0x1000000000000L) && field.isResolved()) {
                    this.appendTypeSignatureLabel((IJavaElement)field, new BindingKey(field.getKey()).toSignature(), flags);
                } else {
                    this.appendTypeSignatureLabel((IJavaElement)field, field.getTypeSignature(), flags);
                }
                this.fBuffer.append(' ');
            }
            if (JavaElementLabelComposerCore.getFlag(flags, 65536L)) {
                this.appendTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
                this.fBuffer.append('.');
            }
            this.fBuffer.append(this.getElementName((IJavaElement)field));
            if (JavaElementLabelComposerCore.getFlag(flags, 16384L) && field.exists() && !Flags.isEnum((int)field.getFlags())) {
                offset = this.fBuffer.length();
                this.fBuffer.append(JavaElementLabelsCore.DECL_STRING);
                if (JavaElementLabelComposerCore.getFlag(flags, 0x1000000000000L) && field.isResolved()) {
                    this.appendTypeSignatureLabel((IJavaElement)field, new BindingKey(field.getKey()).toSignature(), flags);
                } else {
                    this.appendTypeSignatureLabel((IJavaElement)field, field.getTypeSignature(), flags);
                }
                if (JavaElementLabelComposerCore.getFlag(flags, 0x80000000000000L)) {
                    this.setDecorationsStyle(offset);
                }
            }
            if (JavaElementLabelComposerCore.getFlag(flags, 0x2000000000000L) && field.exists()) {
                this.appendCategoryLabel((IMember)field, flags);
            }
            if (JavaElementLabelComposerCore.getFlag(flags, 131072L)) {
                offset = this.fBuffer.length();
                this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
                this.appendTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
                if (JavaElementLabelComposerCore.getFlag(flags, 0x80000000000000L)) {
                    this.setQualifierStyle(offset);
                }
            }
        }
        catch (JavaModelException e) {
            JavaManipulationPlugin.log(e);
        }
    }

    public void appendLocalVariableLabel(ILocalVariable localVariable, long flags) {
        if (JavaElementLabelComposerCore.getFlag(flags, 32768L)) {
            this.appendTypeSignatureLabel((IJavaElement)localVariable, localVariable.getTypeSignature(), flags);
            this.fBuffer.append(' ');
        }
        if (JavaElementLabelComposerCore.getFlag(flags, 65536L)) {
            this.appendElementLabel((IJavaElement)localVariable.getDeclaringMember(), 0x40081L | flags & 0x1002000000000L);
            this.fBuffer.append('.');
        }
        this.fBuffer.append(this.getElementName((IJavaElement)localVariable));
        if (JavaElementLabelComposerCore.getFlag(flags, 16384L)) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(JavaElementLabelsCore.DECL_STRING);
            this.appendTypeSignatureLabel((IJavaElement)localVariable, localVariable.getTypeSignature(), flags);
            if (JavaElementLabelComposerCore.getFlag(flags, 0x80000000000000L)) {
                this.setDecorationsStyle(offset);
            }
        }
        if (JavaElementLabelComposerCore.getFlag(flags, 131072L)) {
            this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
            this.appendElementLabel((IJavaElement)localVariable.getDeclaringMember(), 0x40081L | flags & 0x1002000000000L);
        }
    }

    public void appendTypeParameterLabel(ITypeParameter typeParameter, long flags) {
        try {
            this.appendTypeParameterWithBounds(typeParameter, flags);
            if (JavaElementLabelComposerCore.getFlag(flags, 0x400000L)) {
                this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
                IMember declaringMember = typeParameter.getDeclaringMember();
                this.appendElementLabel((IJavaElement)declaringMember, 0x40081L | flags & 0x1002000000000L);
            }
        }
        catch (JavaModelException e) {
            JavaManipulationPlugin.logException("", e);
        }
    }

    private void appendTypeParameterWithBounds(ITypeParameter typeParameter, long flags) throws JavaModelException {
        String[] bounds;
        this.fBuffer.append(this.getElementName((IJavaElement)typeParameter));
        if (typeParameter.exists() && (bounds = typeParameter.getBoundsSignatures()).length > 0 && (bounds.length != 1 || !"Ljava.lang.Object;".equals(bounds[0]))) {
            this.fBuffer.append(" extends ");
            int j = 0;
            while (j < bounds.length) {
                if (j > 0) {
                    this.fBuffer.append(" & ");
                }
                this.appendTypeSignatureLabel((IJavaElement)typeParameter, bounds[j], flags);
                ++j;
            }
        }
    }

    public void appendInitializerLabel(IInitializer initializer, long flags) {
        if (JavaElementLabelComposerCore.getFlag(flags, 1024L)) {
            this.appendTypeLabel(initializer.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
            this.fBuffer.append('.');
        }
        this.fBuffer.append(JavaElementLabelsMessages.JavaElementLabels_initializer);
        if (JavaElementLabelComposerCore.getFlag(flags, 2048L)) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
            this.appendTypeLabel(initializer.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
            if (JavaElementLabelComposerCore.getFlag(flags, 0x80000000000000L)) {
                this.setQualifierStyle(offset);
            }
        }
    }

    protected void appendTypeSignatureLabel(IJavaElement enclosingElement, String typeSig, long flags) {
        int sigKind = Signature.getTypeSignatureKind((String)typeSig);
        switch (sigKind) {
            case 2: {
                this.fBuffer.append(Signature.toString((String)typeSig));
                break;
            }
            case 4: {
                this.appendTypeSignatureLabel(enclosingElement, Signature.getElementType((String)typeSig), flags);
                int dim = Signature.getArrayCount((String)typeSig);
                while (dim > 0) {
                    this.fBuffer.append('[').append(']');
                    --dim;
                }
                break;
            }
            case 1: {
                String baseType = this.getSimpleTypeName(enclosingElement, typeSig);
                this.fBuffer.append(baseType);
                String[] typeArguments = Signature.getTypeArguments((String)typeSig);
                this.appendTypeArgumentSignaturesLabel(enclosingElement, typeArguments, flags);
                break;
            }
            case 3: {
                this.fBuffer.append(this.getSimpleTypeName(enclosingElement, typeSig));
                break;
            }
            case 5: {
                char ch = typeSig.charAt(0);
                if (ch == '*') {
                    this.fBuffer.append('?');
                    break;
                }
                if (ch == '+') {
                    this.fBuffer.append("? extends ");
                    this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1), flags);
                    break;
                }
                if (ch != '-') break;
                this.fBuffer.append("? super ");
                this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1), flags);
                break;
            }
            case 6: {
                this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1), flags);
                break;
            }
            case 7: {
                String[] typeBounds = Signature.getIntersectionTypeBounds((String)typeSig);
                this.appendTypeBoundsSignaturesLabel(enclosingElement, typeBounds, flags, false);
                break;
            }
            case 8: {
                String[] typeBounds = Signature.getUnionTypeBounds((String)typeSig);
                this.appendTypeBoundsSignaturesLabel(enclosingElement, typeBounds, flags, true);
            }
        }
    }

    private void appendTypeBoundsSignaturesLabel(IJavaElement enclosingElement, String[] typeArgsSig, long flags, boolean isIntersection) {
        int i = 0;
        while (i < typeArgsSig.length) {
            if (i > 0) {
                if (isIntersection) {
                    this.fBuffer.append(" & ");
                } else {
                    this.fBuffer.append(" | ");
                }
            }
            this.appendTypeSignatureLabel(enclosingElement, typeArgsSig[i], flags);
            ++i;
        }
    }

    protected String getSimpleTypeName(IJavaElement enclosingElement, String typeSig) {
        return Signature.getSimpleName((String)Signature.toString((String)Signature.getTypeErasure((String)typeSig)));
    }

    protected String getMemberName(IJavaElement enclosingElement, String typeName, String memberName) {
        return memberName;
    }

    private void appendTypeArgumentSignaturesLabel(IJavaElement enclosingElement, String[] typeArgsSig, long flags) {
        if (typeArgsSig.length > 0) {
            this.fBuffer.append(this.getLT());
            int i = 0;
            while (i < typeArgsSig.length) {
                if (i > 0) {
                    this.fBuffer.append(JavaElementLabelsCore.COMMA_STRING);
                }
                this.appendTypeSignatureLabel(enclosingElement, typeArgsSig[i], flags);
                ++i;
            }
            this.fBuffer.append(this.getGT());
        }
    }

    private void appendTypeParameterSignaturesLabel(String[] typeParamSigs, long flags) {
        if (typeParamSigs.length > 0) {
            this.fBuffer.append(this.getLT());
            int i = 0;
            while (i < typeParamSigs.length) {
                if (i > 0) {
                    this.fBuffer.append(JavaElementLabelsCore.COMMA_STRING);
                }
                this.fBuffer.append(Signature.getTypeVariable((String)typeParamSigs[i]));
                ++i;
            }
            this.fBuffer.append(this.getGT());
        }
    }

    protected String getLT() {
        return "<";
    }

    protected String getGT() {
        return ">";
    }

    public void appendTypeLabel(IType type, long flags) {
        String typeName;
        IPackageFragment pack;
        if (JavaElementLabelComposerCore.getFlag(flags, 262144L) && !(pack = type.getPackageFragment()).isDefaultPackage()) {
            this.appendPackageFragmentLabel(pack, flags & 0x1002000000000L);
            this.fBuffer.append('.');
        }
        IJavaElement parent = type.getParent();
        if (JavaElementLabelComposerCore.getFlag(flags, 786432L)) {
            int parentType;
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                this.appendTypeLabel(declaringType, 0x80000L | flags & 0x1002000000000L);
                this.fBuffer.append('.');
            }
            if ((parentType = parent.getElementType()) == 9 || parentType == 8 || parentType == 10) {
                this.appendElementLabel(parent, 0L);
                this.fBuffer.append('.');
            }
        }
        boolean isAnonymous = false;
        if (type.isLambda()) {
            typeName = "() -> {...}";
            try {
                String[] superInterfaceSignatures = type.getSuperInterfaceTypeSignatures();
                if (superInterfaceSignatures.length > 0) {
                    typeName = String.valueOf(typeName) + ' ' + this.getSimpleTypeName((IJavaElement)type, superInterfaceSignatures[0]);
                }
            }
            catch (JavaModelException javaModelException) {}
        } else {
            typeName = this.getElementName((IJavaElement)type);
            try {
                isAnonymous = type.isAnonymous();
            }
            catch (JavaModelException javaModelException) {
                boolean bl = isAnonymous = typeName.length() == 0;
            }
            if (isAnonymous) {
                try {
                    if (parent instanceof IField && type.isEnum()) {
                        typeName = "{...}";
                    } else {
                        String supertypeName = null;
                        String[] superInterfaceSignatures = type.getSuperInterfaceTypeSignatures();
                        if (superInterfaceSignatures.length > 0) {
                            supertypeName = this.getSimpleTypeName((IJavaElement)type, superInterfaceSignatures[0]);
                        } else {
                            String supertypeSignature = type.getSuperclassTypeSignature();
                            if (supertypeSignature != null) {
                                supertypeName = this.getSimpleTypeName((IJavaElement)type, supertypeSignature);
                            }
                        }
                        typeName = supertypeName == null ? JavaElementLabelsMessages.JavaElementLabels_anonym : Messages.format(JavaElementLabelsMessages.JavaElementLabels_anonym_type, supertypeName);
                    }
                }
                catch (JavaModelException javaModelException) {
                    typeName = JavaElementLabelsMessages.JavaElementLabels_anonym;
                }
            }
        }
        this.fBuffer.append(typeName);
        if (JavaElementLabelComposerCore.getFlag(flags, 0x200000L)) {
            if (JavaElementLabelComposerCore.getFlag(flags, 0x1000000000000L) && type.isResolved()) {
                BindingKey key = new BindingKey(type.getKey());
                if (key.isParameterizedType()) {
                    String[] typeArguments = key.getTypeArguments();
                    this.appendTypeArgumentSignaturesLabel((IJavaElement)type, typeArguments, flags);
                } else {
                    String[] typeParameters = Signature.getTypeParameters((String)key.toSignature());
                    this.appendTypeParameterSignaturesLabel(typeParameters, flags);
                }
            } else if (type.exists()) {
                try {
                    this.appendTypeParametersLabels(type.getTypeParameters(), flags);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        if (JavaElementLabelComposerCore.getFlag(flags, 0x8000000000000L) && type.exists()) {
            try {
                this.appendCategoryLabel((IMember)type, flags);
            }
            catch (JavaModelException javaModelException) {}
        }
        if (JavaElementLabelComposerCore.getFlag(flags, 0x100000L)) {
            String tqn;
            int lastDollar;
            int offset = this.fBuffer.length();
            this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
            IType declaringType = type.getDeclaringType();
            if (declaringType == null && type.isBinary() && isAnonymous && (lastDollar = (tqn = type.getTypeQualifiedName()).lastIndexOf(36)) != 1) {
                String declaringTypeCF = String.valueOf(tqn.substring(0, lastDollar)) + ".class";
                declaringType = type.getPackageFragment().getOrdinaryClassFile(declaringTypeCF).getType();
                try {
                    IJavaElement realParent;
                    ISourceRange typeSourceRange = type.getSourceRange();
                    if (declaringType.exists() && SourceRange.isAvailable((ISourceRange)typeSourceRange) && (realParent = declaringType.getTypeRoot().getElementAt(typeSourceRange.getOffset() - 1)) != null) {
                        parent = realParent;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            if (declaringType != null) {
                this.appendTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L);
                int parentType = parent.getElementType();
                if (parentType == 9 || parentType == 8 || parentType == 10) {
                    this.fBuffer.append('.');
                    this.appendElementLabel(parent, 0L);
                }
            } else {
                this.appendPackageFragmentLabel(type.getPackageFragment(), flags & 0x1002000000000L);
            }
            if (JavaElementLabelComposerCore.getFlag(flags, 0x80000000000000L)) {
                this.setQualifierStyle(offset);
            }
        }
    }

    protected String getElementName(IJavaElement element) {
        return element.getElementName();
    }

    public void appendDeclarationLabel(IJavaElement declaration, long flags) {
        IJavaElement openable;
        if (JavaElementLabelComposerCore.getFlag(flags, 0x1000000L) && (openable = (IJavaElement)declaration.getOpenable()) != null) {
            this.appendElementLabel(openable, 0x88000000L | flags & 0x1002000000000L);
            this.fBuffer.append('/');
        }
        if (declaration.getElementType() == 12) {
            this.fBuffer.append(JavaElementLabelsMessages.JavaElementLabels_import_container);
        } else {
            this.fBuffer.append(this.getElementName(declaration));
        }
        if (JavaElementLabelComposerCore.getFlag(flags, 0x2000000L)) {
            int offset = this.fBuffer.length();
            IJavaElement openable2 = (IJavaElement)declaration.getOpenable();
            if (openable2 != null) {
                this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
                this.appendElementLabel(openable2, 0x88000000L | flags & 0x1002000000000L);
            }
            if (JavaElementLabelComposerCore.getFlag(flags, 0x80000000000000L)) {
                this.setQualifierStyle(offset);
            }
        }
    }

    public void appendClassFileLabel(IClassFile classFile, long flags) {
        IPackageFragment pack;
        if (JavaElementLabelComposerCore.getFlag(flags, 0x8000000L) && !(pack = (IPackageFragment)classFile.getParent()).isDefaultPackage()) {
            this.appendPackageFragmentLabel(pack, flags & 0x1002000000000L);
            this.fBuffer.append('.');
        }
        this.fBuffer.append(classFile.getElementName());
        if (JavaElementLabelComposerCore.getFlag(flags, 0x10000000L)) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
            this.appendPackageFragmentLabel((IPackageFragment)classFile.getParent(), flags & 0x1002000000000L);
            if (JavaElementLabelComposerCore.getFlag(flags, 0x80000000000000L)) {
                this.setQualifierStyle(offset);
            }
        }
    }

    public void appendCompilationUnitLabel(ICompilationUnit cu, long flags) {
        IPackageFragment pack;
        if (JavaElementLabelComposerCore.getFlag(flags, 0x80000000L) && !(pack = (IPackageFragment)cu.getParent()).isDefaultPackage()) {
            this.appendPackageFragmentLabel(pack, flags & 0x1002000000000L);
            this.fBuffer.append('.');
        }
        this.fBuffer.append(cu.getElementName());
        if (JavaElementLabelComposerCore.getFlag(flags, 0x100000000L)) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
            this.appendPackageFragmentLabel((IPackageFragment)cu.getParent(), flags & 0x1002000000000L);
            if (JavaElementLabelComposerCore.getFlag(flags, 0x80000000000000L)) {
                this.setQualifierStyle(offset);
            }
        }
    }

    public void appendPackageFragmentLabel(IPackageFragment pack, long flags) {
        if (JavaElementLabelComposerCore.getFlag(flags, 0x800000000L)) {
            this.appendPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x20000000000L);
            this.fBuffer.append('/');
        }
        if (pack.isDefaultPackage()) {
            this.fBuffer.append(JavaElementLabelsCore.DEFAULT_PACKAGE);
        } else if (JavaElementLabelComposerCore.getFlag(flags, 0x2000000000L)) {
            if (this.isPackageNameAbbreviationEnabled()) {
                this.appendAbbreviatedPackageFragment(pack);
            } else {
                this.appendCompressedPackageFragment(pack);
            }
        } else {
            this.fBuffer.append(this.getElementName((IJavaElement)pack));
        }
        if (JavaElementLabelComposerCore.getFlag(flags, 0x1000000000L)) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
            this.appendPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x20000000000L);
            if (JavaElementLabelComposerCore.getFlag(flags, 0x80000000000000L)) {
                this.setQualifierStyle(offset);
            }
        }
    }

    protected boolean isPackageNameAbbreviationEnabled() {
        return false;
    }

    protected void appendCompressedPackageFragment(IPackageFragment pack) {
        this.appendCompressedPackageFragment(pack.getElementName());
    }

    protected void refreshPackageNamePattern() {
    }

    protected void appendCompressedPackageFragment(String elementName) {
        this.refreshPackageNamePattern();
        if (fgPkgNameLength < 0) {
            this.fBuffer.append(elementName);
            return;
        }
        String name = elementName;
        int start = 0;
        int dot = name.indexOf(46, start);
        while (dot > 0) {
            if (dot - start > fgPkgNameLength - 1) {
                this.fBuffer.append(fgPkgNamePrefix);
                if (fgPkgNameChars > 0) {
                    this.fBuffer.append(name.substring(start, Math.min(start + fgPkgNameChars, dot)));
                }
                this.fBuffer.append(fgPkgNamePostfix);
            } else {
                this.fBuffer.append(name.substring(start, dot + 1));
            }
            start = dot + 1;
            dot = name.indexOf(46, start);
        }
        this.fBuffer.append(name.substring(start));
    }

    protected void appendAbbreviatedPackageFragment(IPackageFragment pack) {
    }

    public void appendPackageFragmentRootLabel(IPackageFragmentRoot root, long flags) {
        if (JavaElementLabelComposerCore.getFlag(flags, 0x10000000000L) && this.appendVariableLabel(root, flags)) {
            return;
        }
        if (root.isArchive()) {
            this.appendArchiveLabel(root, flags);
        } else {
            this.appendFolderLabel(root, flags);
        }
    }

    private void appendArchiveLabel(IPackageFragmentRoot root, long flags) {
        boolean external = root.isExternal();
        if (external) {
            this.appendExternalArchiveLabel(root, flags);
        } else {
            this.appendInternalArchiveLabel(root, flags);
        }
    }

    private boolean appendVariableLabel(IPackageFragmentRoot root, long flags) {
        block10: {
            IClasspathEntry rawEntry;
            block11: {
                try {
                    rawEntry = root.getRawClasspathEntry();
                    if (rawEntry.getEntryKind() != 4) break block10;
                    IClasspathEntry entry = JavaModelUtil.getClasspathEntry(root);
                    if (entry.getReferencingEntry() == null) break block11;
                    return false;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
            IPath path = rawEntry.getPath().makeRelative();
            if (JavaElementLabelComposerCore.getFlag(flags, 0x200000000000L)) {
                int segements = path.segmentCount();
                if (segements > 0) {
                    this.fBuffer.append(path.segment(segements - 1));
                    if (segements > 1) {
                        this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
                        this.fBuffer.append(path.removeLastSegments(1).toOSString());
                    }
                } else {
                    this.fBuffer.append(path.toString());
                }
            } else {
                this.fBuffer.append(path.toString());
            }
            this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
            if (root.isExternal()) {
                this.fBuffer.append(root.getPath().toOSString());
            } else {
                this.fBuffer.append(root.getPath().makeRelative().toString());
            }
            return true;
        }
        return false;
    }

    private void appendExternalArchiveLabel(IPackageFragmentRoot root, long flags) {
        IPath path;
        IClasspathEntry classpathEntry = null;
        try {
            classpathEntry = JavaModelUtil.getClasspathEntry(root);
            IPath rawPath = classpathEntry.getPath();
            path = classpathEntry.getEntryKind() != 5 && !rawPath.isAbsolute() ? rawPath : root.getPath();
        }
        catch (JavaModelException javaModelException) {
            path = root.getPath();
        }
        if (JavaElementLabelComposerCore.getFlag(flags, 0x200000000000L)) {
            int segments = path.segmentCount();
            if (segments > 0) {
                IClasspathEntry referencingEntry;
                this.fBuffer.append(path.segment(segments - 1));
                if (segments > 1 || path.getDevice() != null) {
                    this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
                    this.fBuffer.append(path.removeLastSegments(1).toOSString());
                }
                if (classpathEntry != null && (referencingEntry = classpathEntry.getReferencingEntry()) != null) {
                    this.fBuffer.append(NLS.bind((String)JavaElementLabelsMessages.JavaElementLabels_onClassPathOf, (Object[])new Object[]{Attributes.Name.CLASS_PATH.toString(), referencingEntry.getPath().lastSegment()}));
                }
            } else {
                this.fBuffer.append(path.toOSString());
            }
        } else {
            this.fBuffer.append(path.toOSString());
        }
    }

    private void appendInternalArchiveLabel(IPackageFragmentRoot root, long flags) {
        IResource resource = root.getResource();
        boolean rootQualified = JavaElementLabelComposerCore.getFlag(flags, 0x20000000000L);
        if (rootQualified) {
            this.fBuffer.append(root.getPath().makeRelative().toString());
        } else {
            this.fBuffer.append(root.getElementName());
            boolean referencedPostQualified = JavaElementLabelComposerCore.getFlag(flags, 0x200000000000L);
            if (referencedPostQualified && this.isReferenced(root)) {
                this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
                this.fBuffer.append(resource.getParent().getFullPath().makeRelative().toString());
            } else if (JavaElementLabelComposerCore.getFlag(flags, 0x40000000000L)) {
                this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
                this.fBuffer.append(root.getParent().getPath().makeRelative().toString());
            }
            if (referencedPostQualified) {
                try {
                    IClasspathEntry referencingEntry = JavaModelUtil.getClasspathEntry(root).getReferencingEntry();
                    if (referencingEntry != null) {
                        this.fBuffer.append(NLS.bind((String)JavaElementLabelsMessages.JavaElementLabels_onClassPathOf, (Object[])new Object[]{Attributes.Name.CLASS_PATH.toString(), referencingEntry.getPath().lastSegment()}));
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }

    private void appendFolderLabel(IPackageFragmentRoot root, long flags) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        if (resource == null) {
            this.appendExternalArchiveLabel(root, flags);
            return;
        }
        boolean rootQualified = JavaElementLabelComposerCore.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = JavaElementLabelComposerCore.getFlag(flags, 0x200000000000L) && this.isReferenced(root);
        if (rootQualified) {
            this.fBuffer.append(root.getPath().makeRelative().toString());
        } else {
            IPath projectRelativePath = resource.getProjectRelativePath();
            if (projectRelativePath.segmentCount() == 0) {
                this.fBuffer.append(resource.getName());
                referencedQualified = false;
            } else {
                this.fBuffer.append(projectRelativePath.toString());
            }
            if (referencedQualified) {
                this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
                this.fBuffer.append(resource.getProject().getName());
            } else if (JavaElementLabelComposerCore.getFlag(flags, 0x40000000000L)) {
                this.fBuffer.append(JavaElementLabelsCore.CONCAT_STRING);
                this.fBuffer.append(root.getParent().getElementName());
            } else {
                return;
            }
        }
    }

    private boolean isReferenced(IPackageFragmentRoot root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject jarProject = resource.getProject();
            IProject container = root.getJavaProject().getProject();
            return !container.equals((Object)jarProject);
        }
        return false;
    }

    public static abstract class FlexibleBufferCore {
        public abstract FlexibleBufferCore append(char var1);

        public abstract FlexibleBufferCore append(String var1);

        public abstract int length();
    }

    public static class FlexibleStringBufferCore
    extends FlexibleBufferCore {
        private final StringBuffer fStringBuffer;

        public FlexibleStringBufferCore(StringBuffer stringBuffer) {
            this.fStringBuffer = stringBuffer;
        }

        @Override
        public FlexibleBufferCore append(char ch) {
            this.fStringBuffer.append(ch);
            return this;
        }

        @Override
        public FlexibleBufferCore append(String string) {
            this.fStringBuffer.append(string);
            return this;
        }

        @Override
        public int length() {
            return this.fStringBuffer.length();
        }

        public String toString() {
            return this.fStringBuffer.toString();
        }
    }
}

