/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.rcptt.tesla.internal.ui.player.IScreenCapturer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class SWTScreenCapturer
implements IScreenCapturer {
    public byte[] makeScreenShotData(Display display, int x, int y, int width, int height, Rectangle arect, boolean scale_640_480) {
        GC gc = new GC((Drawable)display);
        Rectangle bounds = display.getBounds();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x + width > bounds.width) {
            width = bounds.width - x;
        }
        if (y + height > bounds.height) {
            height = bounds.height - y;
        }
        if (width <= 0) {
            width = bounds.width;
            x = 0;
        }
        if (height <= 0) {
            y = 0;
            height = bounds.height;
        }
        Image image = new Image((Device)display, width, height);
        gc.copyArea(image, x, y);
        gc.dispose();
        if (arect != null) {
            GC imgGC = new GC((Drawable)image);
            imgGC.setForeground(display.getSystemColor(3));
            imgGC.drawRectangle(arect.x - x, arect.y - y, arect.width - 1, arect.height - 1);
            imgGC.dispose();
        }
        if (scale_640_480) {
            double ra = Math.max((double)width / 640.0, (double)height / 480.0);
            int rx = (int)((double)width / ra);
            int ry = (int)((double)height / ra);
            Image newImage = new Image((Device)display, rx, ry);
            gc = new GC((Drawable)newImage);
            gc.setAntialias(1);
            gc.setInterpolation(2);
            gc.drawImage(image, 0, 0, width, height, 0, 0, rx, ry);
            gc.dispose();
            image.dispose();
            image = newImage;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{image.getImageData()};
        imageLoader.save((OutputStream)bout, 5);
        image.dispose();
        return bout.toByteArray();
    }
}

